/*
 * Decompiled with CFR 0.152.
 */
package com.badgerson.larion.density_function_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Division(DensityFunction argument1, DensityFunction argument2) implements DensityFunction
{
    private static final MapCodec<Division> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument1").forGetter(Division::argument1), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument2").forGetter(Division::argument2)).apply((Applicative)instance, Division::new));
    public static final KeyDispatchDataCodec<Division> CODEC = DensityFunctions.makeCodec(MAP_CODEC);

    public double compute(DensityFunction.FunctionContext context) {
        double dividendValue = this.argument1.compute(context);
        double divisorValue = this.argument2.compute(context);
        if (divisorValue == 0.0) {
            return 0.0;
        }
        double result = dividendValue / divisorValue;
        return result;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider provider) {
        provider.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Division(this.argument1.mapAll(visitor), this.argument2.mapAll(visitor)));
    }

    public double minValue() {
        if (this.argument2.minValue() == 0.0) {
            return 0.0;
        }
        return this.argument1.minValue() / this.argument2.minValue();
    }

    public double maxValue() {
        if (this.argument2.maxValue() == 0.0) {
            return 0.0;
        }
        return this.argument1.maxValue() / this.argument2.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

