/*
 * Decompiled with CFR 0.152.
 */
package com.badgerson.larion.density_function_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Signum(DensityFunction df) implements DensityFunctions.PureTransformer
{
    private static final MapCodec<Signum> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Signum::df)).apply((Applicative)instance, Signum::new));
    public static final KeyDispatchDataCodec<Signum> CODEC = DensityFunctions.makeCodec(MAP_CODEC);

    public DensityFunction input() {
        return this.df;
    }

    public double transform(double density) {
        return Math.signum(density);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return new Signum(this.df.mapAll(visitor));
    }

    public double minValue() {
        return this.transform(this.df.minValue());
    }

    public double maxValue() {
        return this.transform(this.df.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

