/*
 * Decompiled with CFR 0.152.
 */
package com.badgerson.larion.density_function_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Sine(DensityFunction df) implements DensityFunctions.PureTransformer
{
    private static final MapCodec<Sine> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Sine::df)).apply((Applicative)instance, Sine::new));
    public static final KeyDispatchDataCodec<Sine> CODEC = DensityFunctions.makeCodec(MAP_CODEC);

    public DensityFunction input() {
        return this.df;
    }

    public double transform(double density) {
        return Math.sin(density);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return new Sine(this.df.mapAll(visitor));
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

