/*
 * Decompiled with CFR 0.152.
 */
package com.badgerson.larion.density_function_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Sqrt(DensityFunction df) implements DensityFunctions.PureTransformer
{
    private static final MapCodec<Sqrt> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Sqrt::df)).apply((Applicative)instance, Sqrt::new));
    public static final KeyDispatchDataCodec<Sqrt> CODEC = DensityFunctions.makeCodec(MAP_CODEC);

    public DensityFunction input() {
        return this.df;
    }

    public double transform(double density) {
        if (density <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(density);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return new Sqrt(this.df.mapAll(visitor));
    }

    public double minValue() {
        return Math.min(0.0, Math.sqrt(this.df.minValue()));
    }

    public double maxValue() {
        return Math.max(0.0, Math.sqrt(this.df.maxValue()));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

