/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.candlelight.client.gui.LetterGui;
import net.satisfy.candlelight.client.model.CookingBootsModel;
import net.satisfy.candlelight.client.model.CookingChestplateModel;
import net.satisfy.candlelight.client.model.CookingHatModel;
import net.satisfy.candlelight.client.model.CookingLeggingsModel;
import net.satisfy.candlelight.client.model.DinnerBellModel;
import net.satisfy.candlelight.client.model.DressChestplateModel;
import net.satisfy.candlelight.client.model.FlowerCrownModel;
import net.satisfy.candlelight.client.model.TieModel;
import net.satisfy.candlelight.client.model.TypewriterModel;
import net.satisfy.candlelight.client.renderer.block.CompletionistBannerRenderer;
import net.satisfy.candlelight.client.renderer.block.DinnerBellRenderer;
import net.satisfy.candlelight.client.renderer.block.JewelryRenderer;
import net.satisfy.candlelight.client.renderer.block.ShelfRenderer;
import net.satisfy.candlelight.client.renderer.block.StorageBlockEntityRenderer;
import net.satisfy.candlelight.client.renderer.block.StorageTypeRenderer;
import net.satisfy.candlelight.client.renderer.block.TableSetRenderer;
import net.satisfy.candlelight.client.renderer.block.TypewriterRenderer;
import net.satisfy.candlelight.core.registry.EntityTypeRegistry;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.registry.ScreenHandlerTypeRegistry;
import net.satisfy.candlelight.core.registry.StorageTypeRegistry;
import net.satisfy.candlelight.core.util.CandlelightUtil;

@OnlyIn(value=Dist.CLIENT)
public class CandlelightClient {
    public static void initClient() {
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)ObjectRegistry.ROSE.get(), (Block)ObjectRegistry.POTTED_ROSE.get(), (Block)ObjectRegistry.GLASS_BLOCK.get(), (Block)ObjectRegistry.OAK_CHAIR.get(), (Block)ObjectRegistry.DARK_OAK_CHAIR.get(), (Block)ObjectRegistry.SPRUCE_CHAIR.get(), (Block)ObjectRegistry.WARPED_CHAIR.get(), (Block)ObjectRegistry.BIRCH_CHAIR.get(), (Block)ObjectRegistry.MANGROVE_CHAIR.get(), (Block)ObjectRegistry.ACACIA_CHAIR.get(), (Block)ObjectRegistry.CRIMSON_CHAIR.get(), (Block)ObjectRegistry.JUNGLE_CHAIR.get(), (Block)ObjectRegistry.OAK_TABLE.get(), (Block)ObjectRegistry.ACACIA_TABLE.get(), (Block)ObjectRegistry.DARK_OAK_TABLE.get(), (Block)ObjectRegistry.BIRCH_TABLE.get(), (Block)ObjectRegistry.SPRUCE_TABLE.get(), (Block)ObjectRegistry.JUNGLE_TABLE.get(), (Block)ObjectRegistry.MANGROVE_TABLE.get(), (Block)ObjectRegistry.WARPED_TABLE.get(), (Block)ObjectRegistry.CRIMSON_TABLE.get(), (Block)ObjectRegistry.CHAIR.get(), (Block)ObjectRegistry.TABLE.get(), (Block)ObjectRegistry.BAMBOO_CHAIR.get(), (Block)ObjectRegistry.BAMBOO_TABLE.get(), (Block)ObjectRegistry.CHERRY_TABLE.get(), (Block)ObjectRegistry.CHERRY_CHAIR.get(), (Block)ObjectRegistry.WINE_GLASS_BLOCK.get(), (Block)ObjectRegistry.COOKING_POT.get(), (Block)ObjectRegistry.COOKING_PAN.get(), (Block)ObjectRegistry.RED_NETHER_BRICKS_STOVE.get(), (Block)ObjectRegistry.QUARTZ_STOVE.get(), (Block)ObjectRegistry.MUD_STOVE.get(), (Block)ObjectRegistry.END_STOVE.get(), (Block)ObjectRegistry.GRANITE_STOVE.get(), (Block)ObjectRegistry.DEEPSLATE_STOVE.get(), (Block)ObjectRegistry.SANDSTONE_STOVE.get(), (Block)ObjectRegistry.STONE_BRICKS_STOVE.get(), (Block)ObjectRegistry.COBBLESTONE_STOVE.get(), (Block)ObjectRegistry.BAMBOO_STOVE.get()});
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)ObjectRegistry.WINE_GLASS_BLOCK.get(), (Block)ObjectRegistry.TABLE_SET.get(), (Block)ObjectRegistry.GLASS_BLOCK.get()});
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.CANDLELIGHT_BANNER_ENTITY.get()), CompletionistBannerRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.STORAGE_BLOCK_ENTITY.get()), context -> new StorageBlockEntityRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.DINNER_BELL_BLOCK_ENTITY.get()), DinnerBellRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.TYPE_WRITER_BLOCK_ENTITY.get()), TypewriterRenderer::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerTypeRegistry.LETTER_SCREEN_HANDLER.get()), LetterGui::new);
        CandlelightClient.registerStorageType();
        CandlelightUtil.registerColorArmor((Item)ObjectRegistry.DRESS.get(), 0xFF8080);
        CandlelightUtil.registerColorArmor((Item)ObjectRegistry.TROUSERS_AND_VEST.get(), 0x333399);
    }

    public static void registerStorageType(ResourceLocation location, StorageTypeRenderer renderer) {
        StorageBlockEntityRenderer.registerStorageType(location, renderer);
    }

    public static void registerStorageType() {
        CandlelightClient.registerStorageType(StorageTypeRegistry.SHELF, new ShelfRenderer());
        CandlelightClient.registerStorageType(StorageTypeRegistry.TABLE_SET, new TableSetRenderer());
        CandlelightClient.registerStorageType(StorageTypeRegistry.JEWELRY_BOX, new JewelryRenderer());
    }

    public static void preInitClient() {
        CandlelightClient.registerEntityModelLayers();
    }

    public static void registerEntityModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)TypewriterModel.LAYER_LOCATION, TypewriterModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)DinnerBellModel.LAYER_LOCATION, DinnerBellModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)CompletionistBannerRenderer.LAYER_LOCATION, CompletionistBannerRenderer::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)FlowerCrownModel.LAYER_LOCATION, FlowerCrownModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)TieModel.LAYER_LOCATION, TieModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)DressChestplateModel.LAYER_LOCATION, DressChestplateModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CookingHatModel.LAYER_LOCATION, CookingHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CookingChestplateModel.LAYER_LOCATION, CookingChestplateModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CookingLeggingsModel.LAYER_LOCATION, CookingLeggingsModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CookingBootsModel.LAYER_LOCATION, CookingBootsModel::createBodyLayer);
    }
}

