/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import dev.architectury.networking.NetworkManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.candlelight.client.gui.NoteGui;
import net.satisfy.candlelight.core.networking.packet.SignNoteC2SPacket;

@OnlyIn(value=Dist.CLIENT)
public class NotePaperGui
extends NoteGui {
    private final InteractionHand hand;

    public NotePaperGui(Player player, ItemStack itemStack, InteractionHand hand) {
        super(player, itemStack);
        this.hand = hand;
    }

    @Override
    protected void finalizeNote(boolean signNote) {
        if (this.dirty) {
            this.removeEmptyPages();
            this.writeNbtData(signNote);
            int slot = this.hand == InteractionHand.MAIN_HAND ? this.player.getInventory().selected : 40;
            CompoundTag tag = ((CustomData)this.itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            NetworkManager.sendToServer((CustomPacketPayload)new SignNoteC2SPacket(tag, slot, signNote));
        }
    }
}

