/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.core.block.StorageBlock;
import net.satisfy.candlelight.core.block.entity.StorageBlockEntity;
import net.satisfy.candlelight.core.block.entity.TableSetBlockEntity;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.registry.StorageTypeRegistry;
import net.satisfy.candlelight.core.util.CandlelightIdentifier;
import org.jetbrains.annotations.NotNull;

public class TableSetBlock
extends StorageBlock {
    public static final EnumProperty<PlateType> PLATE_TYPE = EnumProperty.create((String)"plate_tye", PlateType.class);
    public static final BooleanProperty WINE_GLASS = BooleanProperty.create((String)"wine_glass");
    public static final BooleanProperty GLASS = BooleanProperty.create((String)"glass");
    public static final BooleanProperty CLOCHE = BooleanProperty.create((String)"cloche");
    public static final BooleanProperty NAPKIN = BooleanProperty.create((String)"napkin");
    public static final BooleanProperty GLASS_DRINK = BooleanProperty.create((String)"glass_drink");
    public static final BooleanProperty WINE_GLASS_DRINK = BooleanProperty.create((String)"wine_glass_drink");
    private static final TagKey<Item> ALL_EFFECTS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CandlelightIdentifier.identifier("all_effects"));

    public TableSetBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.defaultBlockState().setValue((Property)WINE_GLASS, (Comparable)Boolean.valueOf(false))).setValue((Property)GLASS, (Comparable)Boolean.valueOf(false))).setValue((Property)CLOCHE, (Comparable)Boolean.valueOf(false))).setValue((Property)NAPKIN, (Comparable)Boolean.valueOf(false))).setValue((Property)GLASS_DRINK, (Comparable)Boolean.valueOf(false))).setValue((Property)WINE_GLASS_DRINK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TableSetBlockEntity(pos, state, this.size());
    }

    private static HashMap<Item, BooleanProperty> itemHashMap() {
        return (HashMap)Util.make(new HashMap(), map -> {
            map.put((Item)ObjectRegistry.WINE_GLASS.get(), WINE_GLASS);
            map.put((Item)ObjectRegistry.GLASS.get(), GLASS);
            map.put((Item)ObjectRegistry.CLOCHE.get(), CLOCHE);
            map.put((Item)ObjectRegistry.NAPKIN.get(), NAPKIN);
        });
    }

    private static Item getItemFromProperty(BooleanProperty property) {
        return TableSetBlock.itemHashMap().entrySet().stream().filter(entry -> ((BooleanProperty)entry.getValue()).equals((Object)property)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEmpty() && (((Boolean)state.getValue((Property)GLASS_DRINK)).booleanValue() || ((Boolean)state.getValue((Property)WINE_GLASS_DRINK)).booleanValue())) {
            TableSetBlockEntity sbe;
            if (!world.isClientSide() && (sbe = (TableSetBlockEntity)world.getBlockEntity(pos)) != null) {
                if (((Boolean)state.getValue((Property)GLASS_DRINK)).booleanValue()) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)GLASS_DRINK, (Comparable)Boolean.valueOf(false)));
                } else if (((Boolean)state.getValue((Property)WINE_GLASS_DRINK)).booleanValue()) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WINE_GLASS_DRINK, (Comparable)Boolean.valueOf(false)));
                }
                ItemStack effectStack = sbe.getEffectStack();
                if (!effectStack.isEmpty()) {
                    int duration = sbe.getEffectDuration();
                    List effects = ((PotionContents)effectStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects();
                    for (MobEffectInstance effect : effects) {
                        player.addEffect(new MobEffectInstance(effect.getEffect(), duration, effect.getAmplifier()));
                    }
                    sbe.setEffectStack(ItemStack.EMPTY, 0);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (!stack.isEmpty() && stack.getItem().builtInRegistryHolder().is(ALL_EFFECTS)) {
            if (((Boolean)state.getValue((Property)GLASS)).booleanValue() && !((Boolean)state.getValue((Property)GLASS_DRINK)).booleanValue()) {
                TableSetBlockEntity sbe;
                if (!world.isClientSide() && (sbe = (TableSetBlockEntity)world.getBlockEntity(pos)) != null) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)GLASS_DRINK, (Comparable)Boolean.valueOf(true)));
                    if (stack.has(DataComponents.CUSTOM_DATA)) {
                        int duration = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects().stream().mapToInt(MobEffectInstance::getDuration).max().orElse(6000);
                        sbe.setEffectStack(stack.copy(), duration);
                    }
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (((Boolean)state.getValue((Property)WINE_GLASS)).booleanValue() && !((Boolean)state.getValue((Property)WINE_GLASS_DRINK)).booleanValue()) {
                TableSetBlockEntity sbe;
                if (!world.isClientSide() && (sbe = (TableSetBlockEntity)world.getBlockEntity(pos)) != null) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WINE_GLASS_DRINK, (Comparable)Boolean.valueOf(true)));
                    if (stack.has(DataComponents.CUSTOM_DATA)) {
                        int duration = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects().stream().mapToInt(MobEffectInstance::getDuration).max().orElse(6000);
                        sbe.setEffectStack(stack.copy(), duration);
                    }
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
        }
        HashMap<Item, BooleanProperty> items = TableSetBlock.itemHashMap();
        if (player.isShiftKeyDown() && ((Boolean)state.getValue((Property)CLOCHE)).booleanValue()) {
            if (!world.isClientSide()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CLOCHE, (Comparable)Boolean.valueOf(false)));
                ItemStack clocheItem = new ItemStack((ItemLike)TableSetBlock.getItemFromProperty(CLOCHE));
                if (!player.getInventory().add(clocheItem)) {
                    player.drop(clocheItem, false);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        Item item = stack.getItem();
        if (!items.containsKey(item)) {
            return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
        }
        BooleanProperty property = items.get(item);
        if (((Boolean)state.getValue((Property)property)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(true)));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
    }

    @Override
    public void remove(Level world, BlockPos blockPos, Player player, StorageBlockEntity shelfBlockEntity, int i) {
        TableSetBlockEntity tsbe = (TableSetBlockEntity)shelfBlockEntity;
        BlockState state = world.getBlockState(blockPos);
        if (!((Boolean)state.getValue((Property)CLOCHE)).booleanValue() && !world.isClientSide()) {
            ItemStack itemStack = tsbe.removeStack(i);
            SoundEvent soundEvent = SoundEvents.GENERIC_EAT;
            world.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (itemStack.has(DataComponents.FOOD)) {
                FoodProperties foodComponent = (FoodProperties)itemStack.get(DataComponents.FOOD);
                assert (foodComponent != null);
                player.getFoodData().eat(Math.round((float)foodComponent.nutrition() * 1.3f), foodComponent.saturation() * 1.3f);
                foodComponent.effects().forEach(possibleEffect -> player.addEffect(new MobEffectInstance(possibleEffect.effect())));
            }
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
        }
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        List list = super.getDrops(blockState, builder);
        PlateType type = (PlateType)((Object)blockState.getValue(PLATE_TYPE));
        switch (type.ordinal()) {
            case 0: {
                list.add(new ItemStack((ItemLike)ObjectRegistry.PLATE.get()));
                break;
            }
            case 1: {
                list.add(new ItemStack((ItemLike)ObjectRegistry.BOWL.get()));
            }
        }
        for (BooleanProperty property : TableSetBlock.itemHashMap().values()) {
            Item item;
            if (!((Boolean)blockState.getValue((Property)property)).booleanValue() || (item = TableSetBlock.getItemFromProperty(property)) == null) continue;
            list.add(new ItemStack((ItemLike)item));
        }
        return list;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.TABLE_SET;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return stack.has(DataComponents.FOOD);
    }

    @Override
    public int getSection(Float x, Float y) {
        return 0;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.getBlockState(pos.below()).getShape((BlockGetter)world, pos.below());
        return Block.isFaceFull((VoxelShape)shape, (Direction)Direction.UP);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PLATE_TYPE});
        builder.add(new Property[]{WINE_GLASS, GLASS, CLOCHE, NAPKIN, GLASS_DRINK, WINE_GLASS_DRINK});
    }

    private VoxelShape makeBowlShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.125, (double)0.3125, (double)0.1875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.125, (double)0.875, (double)0.1875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.125, (double)0.8125, (double)0.1875, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.6875, (double)0.8125, (double)0.1875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.1875, (double)0.8125, (double)0.0625, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.1875, (double)0.3125, (double)1.0, (double)0.1875, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.1875, (double)0.3125, (double)0.25, (double)0.1875, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private VoxelShape makePlateShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        PlateType type = (PlateType)((Object)state.getValue(PLATE_TYPE));
        if (type.equals((Object)PlateType.BOWL)) {
            return this.rotateShape(direction, this.makeBowlShape());
        }
        return this.rotateShape(direction, this.makePlateShape());
    }

    private VoxelShape rotateShape(Direction direction, VoxelShape shape) {
        if (direction == Direction.NORTH) {
            return shape;
        }
        VoxelShape[] rotatedShapes = new VoxelShape[]{shape};
        for (int i = 0; i < (direction.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4; ++i) {
            rotatedShapes[0] = this.rotateShapeClockwise(rotatedShapes[0]);
        }
        return rotatedShapes[0];
    }

    private VoxelShape rotateShapeClockwise(VoxelShape shape) {
        VoxelShape[] result = new VoxelShape[]{Shapes.empty()};
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double newMinX = 1.0 - maxZ;
            double newMaxX = 1.0 - minZ;
            result[0] = Shapes.or((VoxelShape)result[0], (VoxelShape)Shapes.box((double)newMinX, (double)minY, (double)minX, (double)newMaxX, (double)maxY, (double)maxX));
        });
        return result[0];
    }

    public static enum PlateType implements StringRepresentable
    {
        PLATE("plate"),
        BOWL("bowl");

        private final String name;

        private PlateType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

