/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.core.block.entity.TypewriterEntity;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.util.CandlelightUtil;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypewriterBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING;
    public static final IntegerProperty FULL;
    public static final Map<Direction, VoxelShape> SHAPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    public static final MapCodec<TypewriterBlock> CODEC;

    public TypewriterBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == ObjectRegistry.NOTE_PAPER.get() && (Integer)state.getValue((Property)FULL) == 0) {
            world.setBlock(pos, (BlockState)state.setValue((Property)FULL, (Comparable)Integer.valueOf(1)), 2);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof TypewriterEntity) {
                TypewriterEntity typeWriterEntity = (TypewriterEntity)blockEntity;
                typeWriterEntity.addPaper(new ItemStack((ItemLike)ObjectRegistry.NOTE_PAPER_WRITEABLE.get()));
                stack.setCount(stack.getCount() - 1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if ((Integer)state.getValue((Property)FULL) == 1) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof TypewriterEntity) {
                TypewriterEntity typeWriterEntity = (TypewriterEntity)blockEntity;
                if (world.isClientSide) {
                    CandlelightUtil.setTypeWriterScreen(player, typeWriterEntity);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if ((Integer)state.getValue((Property)FULL) == 2) {
            world.setBlock(pos, (BlockState)state.setValue((Property)FULL, (Comparable)Integer.valueOf(0)), 2);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof TypewriterEntity) {
                TypewriterEntity typeWriterEntity = (TypewriterEntity)blockEntity;
                ItemStack paper = typeWriterEntity.getPaper();
                ItemStack result = new ItemStack((ItemLike)ObjectRegistry.NOTE_PAPER_WRITTEN.get());
                if (paper.has(DataComponents.CUSTOM_DATA)) {
                    result.set(DataComponents.CUSTOM_DATA, (Object)((CustomData)paper.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)));
                }
                ((CustomData)result.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().put("author", (Tag)StringTag.valueOf((String)player.getName().getString()));
                player.addItem(result);
                typeWriterEntity.removePaper();
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)FULL, (Comparable)Integer.valueOf(0));
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity blockEntity;
        if (!blockState.is(blockState2.getBlock()) && (blockEntity = level.getBlockEntity(blockPos)) instanceof TypewriterEntity) {
            TypewriterEntity typeWriterEntity = (TypewriterEntity)blockEntity;
            ItemStack dropStack = typeWriterEntity.getPaper();
            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)dropStack);
        }
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{FULL});
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TypewriterEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    static {
        FULL = IntegerProperty.create((String)"full", (int)0, (int)2);
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.125, (double)0.0625, (double)0.6875, (double)0.1875, (double)0.125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.3125, (double)0.1875, (double)0.3125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.125, (double)0.1875, (double)0.5, (double)0.1875, (double)0.3125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.125, (double)0.1875, (double)0.6875, (double)0.1875, (double)0.3125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.125, (double)0.1875, (double)0.875, (double)0.1875, (double)0.3125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.53125, (double)0.125, (double)0.3125, (double)0.65625, (double)0.25, (double)0.4375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.71875, (double)0.125, (double)0.3125, (double)0.84375, (double)0.25, (double)0.4375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.34375, (double)0.125, (double)0.3125, (double)0.46875, (double)0.25, (double)0.4375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.15625, (double)0.125, (double)0.3125, (double)0.28125, (double)0.25, (double)0.4375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.125, (double)0.4375, (double)0.9375, (double)0.4375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.4375, (double)0.75, (double)0.9375, (double)0.6875, (double)0.875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.4375, (double)0.75, (double)0.1875, (double)0.6875, (double)0.875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5, (double)0.75, (double)0.8125, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.53125, (double)0.875, (double)0.8125, (double)0.65625, (double)0.875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.375, (double)0.84375, (double)0.75, (double)0.75, (double)0.84375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.1875, (double)0.1875, (double)0.1875, (double)0.3125), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        FACING = HorizontalDirectionalBlock.FACING;
        SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
        CODEC = TypewriterBlock.simpleCodec(TypewriterBlock::new);
    }
}

