/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.candlelight.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.Nullable;

public class TypewriterEntity
extends BlockEntity {
    public static final String PAPER_KEY = "paper";
    ItemStack paper = ItemStack.EMPTY;
    private int spaceTicks;
    private int enterTicks;
    private int keyBounceTicks;
    private float lineProgress;
    private int rollerSnapTicks;
    private int bouncingKeyIndex = -1;

    public TypewriterEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.TYPE_WRITER_BLOCK_ENTITY.get(), pos, state);
    }

    public ItemStack getPaper() {
        return this.paper;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (!this.paper.isEmpty()) {
            this.writePaper(compoundTag, this.paper, provider);
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.paper = this.readPaper(compoundTag, provider);
    }

    public void writePaper(CompoundTag nbt, ItemStack stack, HolderLookup.Provider provider) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        stack.save(provider, (Tag)tag);
        nbt.put(PAPER_KEY, (Tag)tag);
    }

    public ItemStack readPaper(CompoundTag nbt, HolderLookup.Provider provider) {
        CompoundTag tag;
        if (nbt.contains(PAPER_KEY) && !(tag = nbt.getCompound(PAPER_KEY)).isEmpty()) {
            return ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public Packet<ClientGamePacketListener> toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag toInitialChunkDataNbt(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void addPaper(ItemStack itemStack) {
        this.paper = itemStack;
        this.setChanged();
    }

    public void removePaper() {
        this.paper = ItemStack.EMPTY;
        this.setChanged();
    }

    public void triggerSpace() {
        this.spaceTicks = 3;
    }

    public void triggerEnter() {
        this.enterTicks = 3;
    }

    public void triggerKeyBounce() {
        this.keyBounceTicks = 2;
        this.bouncingKeyIndex = -1;
    }

    public int getSpaceTicks() {
        return this.spaceTicks;
    }

    public int getEnterTicks() {
        return this.enterTicks;
    }

    public int getKeyBounceTicks() {
        return this.keyBounceTicks;
    }

    public void tickAnimations() {
        if (this.spaceTicks > 0) {
            --this.spaceTicks;
        }
        if (this.enterTicks > 0) {
            --this.enterTicks;
        }
        if (this.keyBounceTicks > 0) {
            --this.keyBounceTicks;
        }
        if (this.rollerSnapTicks > 0) {
            --this.rollerSnapTicks;
        }
        if (this.keyBounceTicks == 0) {
            this.bouncingKeyIndex = -1;
        }
    }

    public void setLineProgress(float v) {
        this.lineProgress = v;
    }

    public float getLineProgress() {
        return this.lineProgress;
    }

    public void snapRoller() {
        this.rollerSnapTicks = 4;
        this.lineProgress = 0.0f;
    }

    public int getRollerSnapTicks() {
        return this.rollerSnapTicks;
    }

    public int getBouncingKeyIndex() {
        return this.bouncingKeyIndex;
    }

    public void setBouncingKeyIndex(int idx) {
        this.bouncingKeyIndex = idx;
    }
}

