/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.api.messaging;

import com.hypherionmc.craterlib.utils.ChatUtils;
import com.hypherionmc.sdlink.SDLinkConstants;
import com.hypherionmc.sdlink.core.config.SDLinkConfig;
import com.hypherionmc.sdlink.core.config.impl.MessageIgnoreConfig;
import com.hypherionmc.sdlink.core.database.SDLinkAccount;
import com.hypherionmc.sdlink.core.discord.BotController;
import com.hypherionmc.sdlink.core.discord.SDLWebhookServerMember;
import com.hypherionmc.sdlink.core.managers.DatabaseManager;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Message;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.MessageReference;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import com.hypherionmc.sdlink.shaded.net.fellbaum.jemoji.EmojiManager;
import com.hypherionmc.sdlink.util.SDLinkChatUtils;
import com.hypherionmc.sdlink.util.translations.Text;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import shadow.kyori.adventure.text.Component;
import shadow.kyori.adventure.text.TextComponent;
import shadow.kyori.adventure.text.event.ClickEvent;
import shadow.kyori.adventure.text.event.HoverEvent;
import shadow.kyori.adventure.text.event.HoverEventSource;
import shadow.kyori.adventure.text.format.NamedTextColor;
import shadow.kyori.adventure.text.format.Style;
import shadow.kyori.adventure.text.format.TextColor;

public final class MessageContext {
    private final Member originalSender;
    private final Message originalMessage;
    @Nullable
    private String formattedMessage;
    @Nullable
    private String formattedReply;
    @Nullable
    private Member replyMember;
    private Member sender;
    final Pattern patternStart = Pattern.compile("%(.*?)(?:\\|(.*?))?%", 2);

    private void parseMessage() {
        String message;
        block7: {
            String attachmentText;
            this.sender = this.originalMessage.isWebhookMessage() ? SDLWebhookServerMember.of(this.originalMessage.getAuthor(), this.originalMessage.getGuild(), this.originalMessage.getJDA()) : this.originalSender;
            message = this.originalMessage.getContentDisplay();
            MessageReference messageReference = this.originalMessage.getMessageReference();
            Message replyReference = this.originalMessage.getReferencedMessage();
            if (messageReference != null && messageReference.getType() == MessageReference.MessageReferenceType.FORWARD) {
                message = this.originalMessage.getMessageSnapshots().get(0).getContentRaw();
            }
            if (!this.originalMessage.getAttachments().isEmpty()) {
                attachmentText = String.valueOf(Text.translate("message.attachments", this.originalMessage.getAttachments().size()));
                String string = message = message.isEmpty() ? String.format("%s attachments", this.originalMessage.getAttachments().size()) : String.format("%s %s", message, attachmentText);
            }
            if (message.isEmpty()) {
                return;
            }
            if (replyReference != null) {
                try {
                    this.replyMember = replyReference.isWebhookMessage() ? SDLWebhookServerMember.of(replyReference.getAuthor(), replyReference.getGuild(), replyReference.getJDA()) : replyReference.getMember();
                    this.formattedReply = replyReference.getContentDisplay();
                    if (!replyReference.getAttachments().isEmpty()) {
                        attachmentText = String.valueOf(Text.translate("message.attachments", replyReference.getAttachments().size()));
                        this.formattedReply = this.formattedReply.isEmpty() ? String.format("%s attachments", replyReference.getAttachments().size()) : String.format("%s %s", this.formattedReply, attachmentText);
                    }
                    this.formattedReply = EmojiManager.replaceAllEmojis(this.formattedReply, emoji -> !emoji.getDiscordAliases().isEmpty() ? emoji.getDiscordAliases().get(0) : emoji.getEmoji());
                }
                catch (Exception e) {
                    if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block7;
                    BotController.INSTANCE.getLogger().error("Failed to process reply formatting: {}", (Object)e.getMessage());
                }
            }
        }
        this.formattedMessage = EmojiManager.replaceAllEmojis(message, emoji -> !emoji.getDiscordAliases().isEmpty() ? emoji.getDiscordAliases().get(0) : emoji.getEmoji());
    }

    public Component getFormattedMessageComponent() {
        AtomicReference<String> user;
        block12: {
            this.parseMessage();
            if (SDLinkConfig.INSTANCE.generalConfig.debugging) {
                SDLinkConstants.LOGGER.info("Got message {} from {}", (Object)this.formattedMessage, (Object)this.sender.getEffectiveName());
            }
            user = new AtomicReference<String>(this.sender.getEffectiveName());
            try {
                if (SDLinkConfig.INSTANCE.chatConfig.useLinkedNames) {
                    List<SDLinkAccount> accounts = DatabaseManager.INSTANCE.getCollection(SDLinkAccount.class);
                    accounts.stream().filter(a -> a.getDiscordID() != null && a.getDiscordID().equals(this.sender.getId())).findFirst().ifPresent(u -> user.set(u.getInGameName()));
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block12;
                SDLinkConstants.LOGGER.error("Failed to load account database: {}", (Object)e.getMessage());
            }
        }
        String mainPrefix = SDLinkConfig.INSTANCE.messageFormatting.mcPrefix.replace("%user%", user.get()).replace("%role%", this.sender.getRoles().isEmpty() ? "No Role" : this.sender.getRoles().get(0).getName());
        String prefix = SDLinkChatUtils.applyFiltering(mainPrefix, i -> i.appliesTo.isMinecraft() && i.appliesTo.appliesToUsername((MessageIgnoreConfig.Ignore)i));
        if (prefix.isEmpty()) {
            prefix = mainPrefix;
        }
        Style baseStyle = Style.empty();
        Component component = this.parsePlaceholders(SDLinkChatUtils.format(prefix), baseStyle, this.sender);
        this.formattedMessage = SDLinkChatUtils.applyFiltering(this.formattedMessage, i -> i.appliesTo.isMinecraft() && i.appliesTo.appliesToChat((MessageIgnoreConfig.Ignore)i));
        if (this.formattedMessage.isEmpty()) {
            return null;
        }
        Component finalComponent = component.append(SDLinkChatUtils.parseChatLinks(this.formattedMessage));
        if (this.formattedReply != null && !this.formattedReply.isEmpty() && this.replyMember != null) {
            String newReply = SDLinkChatUtils.applyFiltering(this.formattedReply, i -> i.appliesTo.isMinecraft() && i.appliesTo.appliesToChat((MessageIgnoreConfig.Ignore)i));
            if (newReply != null && !newReply.isEmpty()) {
                this.formattedReply = newReply;
            }
            finalComponent = this.parsePlaceholders(SDLinkChatUtils.format(SDLinkConfig.INSTANCE.messageFormatting.mcReplyFormatting), Style.style().build(), this.replyMember, this.formattedReply).append(finalComponent);
            if (this.formattedReply.length() > 30) {
                finalComponent = finalComponent.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)SDLinkChatUtils.parseChatLinks(this.formattedReply)));
            }
            try {
                finalComponent = finalComponent.clickEvent(ClickEvent.openUrl((URL)new URL(this.getOriginalMessage().getReferencedMessage().getJumpUrl())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((this.formattedReply == null || this.formattedReply.isEmpty()) && SDLinkConfig.INSTANCE.chatConfig.showDiscordInfo) {
            finalComponent = this.appendDiscordInfo(this.sender, finalComponent);
        }
        return finalComponent;
    }

    private Component parsePlaceholders(Component inComponent, Style baseStyle, Member member) {
        return this.parsePlaceholders(inComponent, baseStyle, member, null);
    }

    private Component parsePlaceholders(Component component, Style baseStyle, Member member, @Nullable String message) {
        TextComponent result = Component.empty();
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            String content = textComponent.content();
            int lastIndex = 0;
            Matcher matcher = this.patternStart.matcher(content);
            while (matcher.find()) {
                String var;
                if (matcher.start() > lastIndex) {
                    result = result.append(Component.text((String)content.substring(lastIndex, matcher.start())).style(baseStyle.merge(textComponent.style())));
                }
                if ((var = matcher.group(1)) != null) {
                    switch (var) {
                        case "color": {
                            baseStyle = baseStyle.color(TextColor.color((int)member.getColorRaw()));
                            break;
                        }
                        case "end_color": {
                            baseStyle = baseStyle.color((TextColor)NamedTextColor.WHITE);
                            break;
                        }
                        case "replier_name": {
                            result = result.append(Component.text((String)member.getEffectiveName()).style(baseStyle.merge(textComponent.style())));
                            break;
                        }
                        case "message_summary": {
                            if (message == null) break;
                            Component msgComponent = SDLinkChatUtils.parseChatLinks(message);
                            if (message.length() > 30) {
                                msgComponent = Component.text((String)(ChatUtils.resolve((Component)msgComponent, (boolean)false).substring(0, 30) + "...")).style(msgComponent.style());
                            }
                            result = result.append(msgComponent.applyFallbackStyle(baseStyle.merge(textComponent.style())));
                            break;
                        }
                        default: {
                            result = result.append(Component.text((String)("%" + var + "%")).style(baseStyle.merge(textComponent.style())));
                        }
                    }
                }
                lastIndex = matcher.end();
            }
            if (lastIndex < content.length()) {
                result = result.append(Component.text((String)content.substring(lastIndex)).style(baseStyle.merge(textComponent.style())));
            }
        }
        for (Component child : component.children()) {
            result = result.append(this.parsePlaceholders(child, baseStyle.merge(component.style()), member, message));
        }
        return result;
    }

    private Component appendDiscordInfo(Member member, Component currentComponent) {
        TextComponent memberDetails = Component.empty();
        memberDetails = memberDetails.append(((TextComponent)((TextComponent)Component.text((String)(Text.translate("tooltip.display_name") + ": ")).style(Style.style().color((TextColor)NamedTextColor.YELLOW).build())).append(Component.text((String)member.getEffectiveName()).style(Style.style().color((TextColor)NamedTextColor.WHITE).build()))).appendNewline()).append(((TextComponent)((TextComponent)Component.text((String)(Text.translate("tooltip.username") + ": ")).style(Style.style().color((TextColor)NamedTextColor.YELLOW).build())).append(Component.text((String)member.getUser().getName()).style(Style.style().color((TextColor)NamedTextColor.WHITE).build()))).appendNewline()).append(((TextComponent)Component.text((String)(Text.translate("tooltip.roles") + ": ")).style(Style.style().color((TextColor)NamedTextColor.YELLOW).build())).append(Component.text((String)String.join((CharSequence)", ", member.getRoles().stream().map(Role::getName).toList())).style(Style.style().color((TextColor)NamedTextColor.WHITE).build())));
        currentComponent = currentComponent.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)memberDetails));
        return currentComponent;
    }

    @Generated
    private MessageContext(Member originalSender, Message originalMessage) {
        this.originalSender = originalSender;
        this.originalMessage = originalMessage;
    }

    @Generated
    public static MessageContext of(Member originalSender, Message originalMessage) {
        return new MessageContext(originalSender, originalMessage);
    }

    @Generated
    public Member getOriginalSender() {
        return this.originalSender;
    }

    @Generated
    public Message getOriginalMessage() {
        return this.originalMessage;
    }

    @Nullable
    @Generated
    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    @Nullable
    @Generated
    public String getFormattedReply() {
        return this.formattedReply;
    }

    @Nullable
    @Generated
    public Member getReplyMember() {
        return this.replyMember;
    }

    @Generated
    public Member getSender() {
        return this.sender;
    }

    @Generated
    public Pattern getPatternStart() {
        return this.patternStart;
    }
}

