/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.core.discord.commands.slash.verification;

import com.hypherionmc.sdlink.api.accounts.MinecraftAccount;
import com.hypherionmc.sdlink.api.messaging.Result;
import com.hypherionmc.sdlink.core.config.SDLinkConfig;
import com.hypherionmc.sdlink.core.database.SDLinkAccount;
import com.hypherionmc.sdlink.core.discord.commands.slash.SDLinkSlashCommand;
import com.hypherionmc.sdlink.core.managers.DatabaseManager;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Guild;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.interactions.commands.OptionType;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.interactions.commands.build.OptionData;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.SlashCommandEvent;
import com.hypherionmc.sdlink.util.translations.Text;
import java.util.Collections;
import java.util.List;

public final class VerifyAccountCommand
extends SDLinkSlashCommand {
    public VerifyAccountCommand() {
        super(false);
        this.name = "verify";
        this.help = Text.translate("command.verify.help").toString();
        this.guildOnly = false;
        this.options = Collections.singletonList(new OptionData(OptionType.INTEGER, "code", "The verification code from the Minecraft Kick Message").setRequired(true));
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        Member m;
        Guild guild;
        int mcCode;
        if (!SDLinkConfig.INSTANCE.accessControl.allowVerifyInDm && !event.isFromGuild()) {
            return;
        }
        event.deferReply(SDLinkConfig.INSTANCE.botConfig.silentReplies).queue();
        int n = mcCode = event.getOption("code") != null ? event.getOption("code").getAsInt() : 0;
        if (mcCode == 0) {
            event.getHook().sendMessage(Text.translate("command.verify.missing_code").toString()).setEphemeral(SDLinkConfig.INSTANCE.botConfig.silentReplies).queue();
            return;
        }
        List<SDLinkAccount> accounts = DatabaseManager.INSTANCE.findAll(SDLinkAccount.class);
        if (accounts.isEmpty()) {
            event.getHook().sendMessage(Text.translate("error.no_db_accounts").toString()).setEphemeral(SDLinkConfig.INSTANCE.botConfig.silentReplies).queue();
            return;
        }
        Guild guild2 = event.isFromGuild() ? event.getGuild() : (guild = event.getJDA().getGuilds().isEmpty() ? null : event.getJDA().getGuilds().get(0));
        if (guild == null) {
            event.getHook().sendMessage(Text.translate("error.no_discord_server").toString()).setEphemeral(SDLinkConfig.INSTANCE.botConfig.silentReplies).queue();
            return;
        }
        Member member = m = event.isFromGuild() ? event.getMember() : guild.getMemberById(event.getUser().getId());
        if (m == null) {
            event.getHook().sendMessage(Text.translate("error.not_a_member_of", guild.getName()).toString()).setEphemeral(SDLinkConfig.INSTANCE.botConfig.silentReplies).queue();
            return;
        }
        boolean didVerify = false;
        for (SDLinkAccount account : accounts) {
            if (account.getVerifyCode() == null) continue;
            if (accounts.stream().anyMatch(a -> a.getDiscordID() != null && a.getDiscordID().equals(m.getId())) && !SDLinkConfig.INSTANCE.accessControl.allowMultipleAccounts) {
                event.getHook().sendMessage(Text.translate("command.verify.already_verified").toString()).queue();
                return;
            }
            if (!account.getVerifyCode().equalsIgnoreCase(String.valueOf(mcCode))) continue;
            MinecraftAccount minecraftAccount = MinecraftAccount.of(account);
            Result result = minecraftAccount.verifyAccount(m, guild);
            event.getHook().sendMessage(result.getMessage()).setEphemeral(true).queue();
            didVerify = true;
            break;
        }
        if (!didVerify) {
            event.getHook().sendMessage(Text.translate("command.verify.failed").toString()).setEphemeral(SDLinkConfig.INSTANCE.botConfig.silentReplies).queue();
        }
    }
}

