/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.worker;

import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.sampler.ChunkSampler;
import caeruleustait.world.preview.backend.worker.SampleUtils;
import caeruleustait.world.preview.backend.worker.WorkResult;
import caeruleustait.world.preview.backend.worker.WorkUnit;
import caeruleustait.world.preview.mixin.NoiseChunkAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;

public class IntersectionWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int numChunks;
    private final int yStride;

    public IntersectionWorkUnit(ChunkSampler sampler, SampleUtils sampleUtils, ChunkPos chunkPos, int numChunks, PreviewData previewData, int yStride) {
        super(sampleUtils, chunkPos, previewData, 0);
        this.sampler = sampler;
        this.numChunks = numChunks;
        this.yStride = yStride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<WorkResult> doWork() {
        NoiseGeneratorSettings noiseGeneratorSettings = this.sampleUtils.noiseGeneratorSettings();
        if (noiseGeneratorSettings == null) {
            return List.of();
        }
        NoiseSettings noiseSettings = noiseGeneratorSettings.noiseSettings();
        NoiseChunk noiseChunk = this.sampleUtils.getNoiseChunk(this.chunkPos, this.numChunks, true);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int yMin = noiseSettings.minY();
        int yMax = yMin + noiseSettings.height();
        int cellWidth = noiseSettings.getCellWidth();
        int cellHeight = noiseSettings.getCellHeight();
        int cellMinY = Mth.floorDiv((int)yMin, (int)noiseSettings.getCellHeight());
        int cellCountY = Mth.floorDiv((int)noiseSettings.height(), (int)noiseSettings.getCellHeight());
        int minBlockX = this.chunkPos.getMinBlockX();
        int minBlockZ = this.chunkPos.getMinBlockZ();
        int cellCountXZ = 16 * this.numChunks / cellWidth;
        int cellStrideXZ = Math.max(1, this.sampler.blockStride() / cellWidth);
        int todoArraySize = Math.max(1, cellWidth / this.sampler.blockStride()) * Math.max(1, cellWidth / this.sampler.blockStride());
        ArrayList<WorkResult> results = new ArrayList<WorkResult>((yMax - yMin) / this.yStride);
        for (int y = yMin; y <= yMax; y += this.yStride) {
            results.add(new WorkResult(this, QuartPos.fromBlock((int)y), y == this.y ? this.primarySection : this.storage.section4(this.chunkPos, y, this.flags()), new ArrayList<WorkResult.BlockResult>(this.numChunks * this.numChunks * 4 * 4), List.of()));
        }
        noiseChunk.initializeForFirstCellX();
        try {
            for (int cellX = 0; cellX < cellCountXZ && !this.isCanceled(); cellX += cellStrideXZ) {
                noiseChunk.advanceCellX(cellX);
                for (int cellZ = 0; cellZ < cellCountXZ && !this.isCanceled(); cellZ += cellStrideXZ) {
                    ArrayList<XZPair> positions = new ArrayList<XZPair>(todoArraySize);
                    for (int xInCell = 0; xInCell < cellWidth; xInCell += this.sampler.blockStride()) {
                        for (int zInCell = 0; zInCell < cellWidth; zInCell += this.sampler.blockStride()) {
                            int x = minBlockX + cellX * cellWidth + xInCell;
                            int z = minBlockZ + cellZ * cellWidth + zInCell;
                            positions.add(new XZPair(x, (double)xInCell / (double)cellWidth, z, (double)zInCell / (double)cellWidth, new AtomicInteger(0)));
                        }
                    }
                    int lastCellY = Integer.MIN_VALUE;
                    for (int yTemp = yMin; yTemp <= yMax; yTemp += this.yStride) {
                        int y = Math.min(yTemp, yMax - 1);
                        int cellY = Math.min(Math.floorDiv(y - yMin, cellHeight), cellCountY - 1);
                        int yInCell = y % cellHeight;
                        if (cellY != lastCellY) {
                            noiseChunk.selectCellYZ(cellY, cellZ);
                        }
                        noiseChunk.updateForY(y, (double)yInCell / (double)cellHeight);
                        lastCellY = cellY;
                        WorkResult res = (WorkResult)results.get((yTemp - yMin) / this.yStride);
                        for (XZPair curr : positions) {
                            noiseChunk.updateForX(curr.x, curr.dX);
                            noiseChunk.updateForZ(curr.z, curr.dZ);
                            BlockState blockState = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
                            if (blockState == null) {
                                blockState = noiseGeneratorSettings.defaultBlock();
                            }
                            short colorId = (short)blockState.getMapColor(null, null).id;
                            short lastId = (short)curr.mutableLastValue.getAndSet(colorId);
                            if (colorId == 0 && lastId > 0) {
                                colorId = -lastId;
                            }
                            mutableBlockPos.set(curr.x, yTemp, curr.z);
                            this.sampler.expandRaw((BlockPos)mutableBlockPos, colorId, res);
                        }
                    }
                }
                noiseChunk.swapSlices();
            }
        }
        finally {
            noiseChunk.stopInterpolation();
        }
        return results;
    }

    @Override
    public long flags() {
        return 3L;
    }

    private record XZPair(int x, double dX, int z, double dZ, AtomicInteger mutableLastValue) {
    }
}

