/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.client.gui.widgets;

import caeruleustait.world.preview.RenderSettings;
import caeruleustait.world.preview.WorldPreview;
import caeruleustait.world.preview.WorldPreviewConfig;
import caeruleustait.world.preview.backend.WorkManager;
import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.storage.PreviewSection;
import caeruleustait.world.preview.backend.storage.PreviewStorage;
import caeruleustait.world.preview.client.WorldPreviewClient;
import caeruleustait.world.preview.client.WorldPreviewComponents;
import caeruleustait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleustait.world.preview.client.gui.widgets.lists.BiomesList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import it.unimi.dsi.fastutil.shorts.Short2LongOpenHashMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PreviewDisplay
extends AbstractWidget
implements AutoCloseable {
    private final Minecraft minecraft;
    private final PreviewDisplayDataProvider dataProvider;
    private final WorkManager workManager;
    private final RenderSettings renderSettings;
    private final WorldPreviewConfig config;
    private Short2LongMap visibleBiomes;
    private Short2LongMap visibleStructures;
    private NativeImage previewImg;
    private DynamicTexture previewTexture;
    private long[] workingVisibleBiomes;
    private long[] workingVisibleStructures;
    private int[] colorMap;
    private int[] colorMapGrayScale;
    private int[] heightColorMap;
    private int[] noiseColorMap;
    private boolean[] cavesMap;
    private IconData[] structureIcons;
    private IconData playerIcon;
    private IconData spawnIcon;
    private ItemStack[] structureItems;
    private PreviewDisplayDataProvider.StructureRenderInfo[] structureRenderInfoMap;
    private final NativeImage dummyIcon;
    private Component coordinatesCopiedMsg = null;
    private Instant coordinatesCopiedTime = null;
    private int texWidth = 100;
    private int texHeight = 100;
    private short selectedBiomeId;
    private boolean highlightCaves;
    private double totalDragX = 0.0;
    private double totalDragZ = 0.0;
    private int scaleBlockPos = 1;
    private StructHoverHelperCell[] hoverHelperGrid;
    private final int hoverHelperGridCellSize = 64;
    private int hoverHelperGridWidth;
    private int hoverHelperGridHeight;
    private Queue<Long> frametimes = new ArrayDeque<Long>();
    private boolean clicked = false;

    public PreviewDisplay(Minecraft minecraft, PreviewDisplayDataProvider dataProvider, Component component) {
        super(0, 0, 100, 100, component);
        this.minecraft = minecraft;
        this.workManager = WorldPreview.get().workManager();
        this.dataProvider = dataProvider;
        this.visibleBiomes = new Short2LongOpenHashMap();
        this.visibleStructures = new Short2LongOpenHashMap();
        this.renderSettings = WorldPreview.get().renderSettings();
        this.config = WorldPreview.get().cfg();
        this.dummyIcon = new NativeImage(16, 16, true);
        this.structureIcons = new IconData[0];
        this.resizeImage();
    }

    public void resizeImage() {
        this.closeDisplayTextures();
        this.previewImg = new NativeImage(NativeImage.Format.RGBA, this.texWidth, this.texHeight, true);
        this.previewTexture = new DynamicTexture(this.previewImg);
        this.scaleBlockPos = 4 / this.renderSettings.quartExpand() * this.renderSettings.quartStride();
        this.hoverHelperGridWidth = this.texWidth / 64 + 1;
        this.hoverHelperGridHeight = this.texHeight / 64 + 1;
        this.hoverHelperGrid = new StructHoverHelperCell[this.hoverHelperGridWidth * this.hoverHelperGridHeight];
        for (int i = 0; i < this.hoverHelperGrid.length; ++i) {
            this.hoverHelperGrid[i] = new StructHoverHelperCell(new ArrayList<StructHoverHelperEntry>());
        }
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.texWidth = this.width * (int)this.minecraft.getWindow().getGuiScale();
        this.texHeight = this.height * (int)this.minecraft.getWindow().getGuiScale();
        this.resizeImage();
    }

    public void reloadData() {
        this.closeIconTextures();
        PreviewData.BiomeData[] rawBiomeMap = this.dataProvider.previewData().biomeId2BiomeData();
        this.structureRenderInfoMap = this.dataProvider.renderStructureMap();
        this.structureItems = this.dataProvider.structureItems();
        this.structureIcons = (IconData[])Arrays.stream(this.dataProvider.structureIcons()).map(x -> new IconData((NativeImage)x, new DynamicTexture(x))).toArray(IconData[]::new);
        this.playerIcon = new IconData(this.dataProvider.playerIcon(), new DynamicTexture(this.dataProvider.playerIcon()));
        this.spawnIcon = new IconData(this.dataProvider.spawnIcon(), new DynamicTexture(this.dataProvider.spawnIcon()));
        this.playerIcon.texture.upload();
        this.spawnIcon.texture.upload();
        Arrays.stream(this.structureIcons).map(IconData::texture).forEach(DynamicTexture::upload);
        try {
            this.heightColorMap = this.dataProvider.heightColorMap();
            this.noiseColorMap = this.dataProvider.noiseColorMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.workingVisibleBiomes = new long[rawBiomeMap.length];
        this.workingVisibleStructures = new long[this.structureIcons.length];
        this.colorMap = new int[rawBiomeMap.length];
        this.colorMapGrayScale = new int[rawBiomeMap.length];
        this.cavesMap = new boolean[rawBiomeMap.length];
        for (int i = 0; i < rawBiomeMap.length; i = (int)((short)(i + 1))) {
            this.colorMap[i] = PreviewDisplay.textureColor(rawBiomeMap[i].color());
            this.colorMapGrayScale[i] = PreviewDisplay.grayScale(this.colorMap[i]);
            this.cavesMap[i] = rawBiomeMap[i].isCave();
        }
    }

    private void closeIconTextures() {
        if (this.structureIcons != null) {
            Arrays.stream(this.structureIcons).forEach(IconData::close);
        }
        if (this.playerIcon != null) {
            this.playerIcon.texture.close();
        }
        if (this.spawnIcon != null) {
            this.spawnIcon.texture.close();
        }
    }

    private void closeDisplayTextures() {
        if (this.previewTexture != null) {
            this.previewTexture.close();
        }
        if (this.previewImg != null) {
            this.previewImg.close();
        }
    }

    @Override
    public void close() {
        this.closeIconTextures();
        this.closeDisplayTextures();
    }

    public BlockPos center() {
        if (this.totalDragX == 0.0 && this.totalDragZ == 0.0) {
            return this.renderSettings.center();
        }
        return new BlockPos((int)((double)this.renderSettings.center().getX() + this.totalDragX), this.renderSettings.center().getY(), (int)((double)this.renderSettings.center().getZ() + this.totalDragZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderWidget(GuiGraphics guiGraphics, int x, int y, float f) {
        int colorBorder = -10066330;
        int xMin = this.getX();
        int yMin = this.getY();
        int xMax = xMin + this.width;
        int yMax = yMin + this.height;
        double winWidth = this.minecraft.getWindow().getWidth();
        double winHeight = this.minecraft.getWindow().getHeight();
        double guiScale = this.minecraft.getWindow().getGuiScale();
        Instant renderStart = Instant.now();
        this.queueGeneration();
        PreviewDisplayDataProvider previewDisplayDataProvider = this.dataProvider;
        synchronized (previewDisplayDataProvider) {
            if (this.dataProvider.setupFailed()) {
                this.previewImg.fillRect(0, 0, this.texWidth, this.texHeight, -16777216);
                this.previewTexture.upload();
                WorldPreviewClient.renderTexture((AbstractTexture)this.previewTexture, xMin, yMin, xMax, yMax);
                List<MutableComponent> lines = WorldPreviewComponents.MSG_ERROR_SETUP_FAILED.getString().lines().map(Component::literal).toList();
                int centerX = this.getX() + this.width / 2;
                int n = this.getY() + this.height / 2;
                int n2 = lines.size() / 2;
                Objects.requireNonNull(this.minecraft.font);
                int centerY = n - n2 * (9 + 4);
                for (int i = 0; i < lines.size(); ++i) {
                    Component line = (Component)lines.get(i);
                    Objects.requireNonNull(this.minecraft.font);
                    int offsetY = i * (9 + 4);
                    guiGraphics.drawCenteredString(this.minecraft.font, line, centerX, centerY + offsetY, 0xFFFFFF);
                }
            } else if (this.dataProvider.isUpdating()) {
                this.previewImg.fillRect(0, 0, this.texWidth, this.texHeight, -16777216);
                this.previewTexture.upload();
                WorldPreviewClient.renderTexture((AbstractTexture)this.previewTexture, xMin, yMin, xMax, yMax);
                int centerX = this.getX() + this.width / 2;
                int centerY = this.getY() + this.height / 2;
                guiGraphics.drawCenteredString(this.minecraft.font, WorldPreviewComponents.MSG_PREVIEW_SETUP_LOADING, centerX, centerY, 0xFFFFFF);
            } else {
                Arrays.fill(this.workingVisibleBiomes, 0L);
                Arrays.fill(this.workingVisibleStructures, 0L);
                Arrays.stream(this.hoverHelperGrid).forEach(cell -> cell.entries.clear());
                List<RenderHelper> renderData = this.generateRenderData();
                this.updateTexture(renderData);
                this.previewTexture.upload();
                WorldPreviewClient.renderTexture((AbstractTexture)this.previewTexture, xMin, yMin, xMax, yMax);
                guiGraphics.enableScissor(xMin, yMin, xMax, yMax);
                Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)winWidth, (float)winHeight, 0.0f, 1000.0f, 21000.0f);
                RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
                this.renderStructures(renderData, guiGraphics);
                this.renderPlayerAndSpawn();
                matrix4f = new Matrix4f().setOrtho(0.0f, (float)(winWidth / guiScale), (float)(winHeight / guiScale), 0.0f, 1000.0f, 21000.0f);
                RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
                guiGraphics.disableScissor();
                double mouseX = this.minecraft.mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                double mouseZ = this.minecraft.mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
                this.biomesChanged();
                this.updateTooltip(mouseX, mouseZ);
            }
        }
        guiGraphics.fill(xMin - 1, yMin - 1, xMax + 1, yMin, -10066330);
        guiGraphics.fill(xMax, yMin, xMax + 1, yMax, -10066330);
        guiGraphics.fill(xMin - 1, yMax, xMax + 1, yMax + 1, -10066330);
        guiGraphics.fill(xMin - 1, yMin, xMin, yMax, -10066330);
        if (this.coordinatesCopiedMsg != null) {
            guiGraphics.fill(xMin, yMax - 38, xMax, yMax - 19, -1442840576);
            guiGraphics.drawCenteredString(this.minecraft.font, this.coordinatesCopiedMsg, xMin + (xMax - xMin) / 2, yMax - 32, 0xFFFFFF);
            if (Duration.between(this.coordinatesCopiedTime, Instant.now()).toSeconds() >= 8L) {
                this.coordinatesCopiedMsg = null;
                this.coordinatesCopiedTime = null;
            }
        }
        Instant renderEnd = Instant.now();
        this.frametimes.add(Duration.between(renderStart, renderEnd).abs().toMillis());
        while (this.frametimes.size() > 30) {
            this.frametimes.poll();
        }
        long sum = this.frametimes.stream().reduce(0L, Long::sum);
        if (this.config.showFrameTime) {
            guiGraphics.drawString(this.minecraft.font, sum / (long)this.frametimes.size() + " ms", 5, 5, 0xFFFFFF);
        }
    }

    private TextureCoordinate blockToTexture(BlockPos blockPos) {
        BlockPos center = this.center();
        int xMin = center.getX() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int zMin = center.getZ() - this.texHeight * this.scaleBlockPos / 2 - 1;
        return new TextureCoordinate((blockPos.getX() - xMin) / 4 * 4 / this.scaleBlockPos, (blockPos.getZ() - zMin) / 4 * 4 / this.scaleBlockPos);
    }

    private void putHoverStructEntry(TextureCoordinate pos, StructHoverHelperEntry entry) {
        int cellX = Math.max(0, Math.min(this.hoverHelperGridWidth - 1, pos.x / 64));
        int cellZ = Math.max(0, Math.min(this.hoverHelperGridHeight - 1, pos.z / 64));
        this.hoverHelperGrid[cellX * this.hoverHelperGridHeight + cellZ].entries.add(entry);
    }

    private void queueGeneration() {
        BlockPos center = this.center();
        int xMin = center.getX() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int xMax = center.getX() + this.texWidth * this.scaleBlockPos / 2 + 1;
        int zMin = center.getZ() - this.texHeight * this.scaleBlockPos / 2 - 1;
        int zMax = center.getZ() + this.texHeight * this.scaleBlockPos / 2 + 1;
        int y = center.getY();
        this.workManager.queueRange(new BlockPos(xMin, y, zMin), new BlockPos(xMax, y, zMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RenderHelper> generateRenderData() {
        PreviewStorage storage;
        BlockPos center = this.center();
        int xMin = center.getX() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int zMin = center.getZ() - this.texHeight * this.scaleBlockPos / 2 - 1;
        int quartExpand = this.renderSettings.quartExpand();
        int quartStride = this.renderSettings.quartStride();
        int quartsInWidth = this.texWidth / quartExpand * quartStride;
        int quartsInHeight = this.texHeight / quartExpand * quartStride;
        int minQuartX = QuartPos.fromBlock((int)xMin);
        int minQuartZ = QuartPos.fromBlock((int)zMin);
        int maxQuartX = minQuartX + quartsInWidth;
        int maxQuartZ = minQuartZ + quartsInHeight;
        int quartX = minQuartX;
        int quartY = QuartPos.fromBlock((int)center.getY());
        int quartZ = minQuartZ;
        int sectionStartTexX = 0;
        int sectionStartTexZ = 0;
        ArrayList<RenderHelper> res = new ArrayList<RenderHelper>((quartsInWidth / 64 + 2) * (quartsInHeight / 64 + 2));
        PreviewStorage previewStorage = storage = this.workManager.previewStorage();
        synchronized (previewStorage) {
            while (true) {
                long flag = this.renderSettings.mode.flag;
                int useY = this.renderSettings.mode.useY ? quartY : 0;
                PreviewSection dataSection = storage.section4(quartX, useY, quartZ, flag);
                PreviewSection structureSection = storage.section4(quartX, 0, quartZ, 1L);
                PreviewSection.AccessData accessData = dataSection.calcQuartOffsetData(quartX, quartZ, maxQuartX, maxQuartZ);
                res.add(new RenderHelper(dataSection, structureSection, accessData, sectionStartTexX, sectionStartTexZ));
                if (accessData.continueX()) {
                    int quartDiffX = accessData.maxX() - accessData.minX();
                    quartX += quartDiffX;
                    sectionStartTexX += quartDiffX * quartExpand / quartStride;
                    continue;
                }
                if (!accessData.continueZ()) break;
                int quartDiffZ = accessData.maxZ() - accessData.minZ();
                quartX = minQuartX;
                quartZ += quartDiffZ;
                sectionStartTexZ += quartDiffZ * quartExpand / quartStride;
                sectionStartTexX = 0;
            }
        }
        return res;
    }

    private void updateTexture(List<RenderHelper> renderData) {
        int texX = 0;
        int texZ = 0;
        int quartExpand = this.renderSettings.quartExpand();
        int quartStride = this.renderSettings.quartStride();
        for (RenderHelper r : renderData) {
            texX = r.sectionStartTexX;
            for (int x = r.accessData.minX(); x < r.accessData.maxX(); x += quartStride) {
                texZ = r.sectionStartTexZ;
                for (int z = r.accessData.minZ(); z < r.accessData.maxZ(); z += quartStride) {
                    short rawData = r.dataSection.get(x, z);
                    int color = -16777216;
                    switch (this.renderSettings.mode) {
                        case BIOMES: {
                            if (rawData < 0) break;
                            int n = color = this.selectedBiomeId >= 0 || this.highlightCaves ? this.colorMapGrayScale[rawData] : this.colorMap[rawData];
                            if (this.selectedBiomeId == rawData || this.highlightCaves && this.cavesMap[rawData]) {
                                color = this.colorMap[rawData];
                            }
                            short s = rawData;
                            this.workingVisibleBiomes[s] = this.workingVisibleBiomes[s] + 1L;
                            break;
                        }
                        case HEIGHTMAP: {
                            if (rawData <= Short.MIN_VALUE) break;
                            color = this.heightColorMap[rawData - this.dataProvider.yMin()];
                            break;
                        }
                        case INTERSECTIONS: {
                            if (rawData >= 0) {
                                color = MapColor.byId((int)rawData).col;
                                color = PreviewDisplay.textureColor(color == 0 ? 0xFFFFFF : color);
                                break;
                            }
                            if (rawData <= Short.MIN_VALUE) break;
                            color = MapColor.byId((int)(-rawData)).col;
                            color = PreviewDisplay.highlightColor(PreviewDisplay.textureColor(color == 0 ? 0xFFFFFF : color));
                            break;
                        }
                        case NOISE_TEMPERATURE: 
                        case NOISE_HUMIDITY: 
                        case NOISE_CONTINENTALNESS: 
                        case NOISE_EROSION: 
                        case NOISE_DEPTH: 
                        case NOISE_WEIRDNESS: {
                            if (rawData <= Short.MIN_VALUE) break;
                            float data = (float)rawData / 32767.0f;
                            int idx = Math.min(1023, Math.max(0, 512 + (int)(data * 512.0f)));
                            color = this.noiseColorMap[idx];
                            break;
                        }
                        case NOISE_PEAKS_AND_VALLEYS: {
                            if (rawData <= Short.MIN_VALUE) break;
                            float data = (float)rawData / 0.75f / 32767.0f;
                            float pvData = NoiseRouterData.peaksAndValleys((float)Math.min(1.0f, Math.max(-1.0f, data)));
                            int idx = Math.min(1023, Math.max(0, 512 + (int)(pvData * 512.0f)));
                            color = this.noiseColorMap[idx];
                        }
                    }
                    if (quartExpand > 1) {
                        this.previewImg.fillRect(texX, texZ, Math.min(this.texWidth - texX, quartExpand), Math.min(this.texHeight - texZ, quartExpand), color);
                    } else {
                        this.previewImg.setPixelRGBA(texX, texZ, color);
                    }
                    texZ += quartExpand;
                }
                texX += quartExpand;
            }
        }
    }

    private void renderStructures(List<RenderHelper> renderData, GuiGraphics guiGraphics) {
        if (!this.config.sampleStructures) {
            return;
        }
        double guiScale = this.minecraft.getWindow().getGuiScale();
        for (RenderHelper r : renderData) {
            for (PreviewSection.PreviewStruct structure : r.structureSection.structures()) {
                short id = structure.structureId();
                TextureCoordinate texCenter = this.blockToTexture(structure.center());
                IconData iconData = this.structureIcons[id];
                NativeImage icon = iconData.img;
                DynamicTexture iconTexture = iconData.texture;
                ItemStack item = this.structureItems[id];
                if (icon == null && item == null) continue;
                if (icon == null) {
                    icon = this.dummyIcon;
                }
                int xMin = -(icon.getWidth() / 2);
                int xMax = icon.getWidth() / 2 + 1 + this.texWidth;
                int zMin = -(icon.getHeight() / 2);
                int zMax = icon.getHeight() / 2 + 1 + this.texHeight;
                if (texCenter.x < xMin || texCenter.z < zMin || texCenter.x > xMax || texCenter.z > zMax) continue;
                short s = id;
                this.workingVisibleStructures[s] = this.workingVisibleStructures[s] + 1L;
                if (!this.structureRenderInfoMap[id].show() || this.renderSettings.hideAllStructures) continue;
                int texStartX = texCenter.x - icon.getWidth() / 2;
                int texStartZ = texCenter.z - icon.getHeight() / 2;
                int rXMin = (int)((double)texStartX + (double)this.getX() * guiScale);
                int rZMin = (int)((double)texStartZ + (double)this.getY() * guiScale);
                int rXMax = rXMin + icon.getWidth();
                int rZMax = rZMin + icon.getHeight();
                if (item != null) {
                    guiGraphics.renderItem(item, rXMin, rZMin);
                } else if (iconTexture != null) {
                    WorldPreviewClient.renderTexture((AbstractTexture)iconTexture, rXMin, rZMin, rXMax, rZMax);
                }
                this.putHoverStructEntry(texCenter, new StructHoverHelperEntry(new BoundingBox(texStartX, 0, texStartZ, texStartX + icon.getWidth(), 0, texStartZ + icon.getHeight()), structure));
            }
        }
    }

    private void renderPlayerAndSpawn() {
        if (!this.config.showPlayer) {
            return;
        }
        PreviewDisplayDataProvider.PlayerData playerData = this.dataProvider.getPlayerData(this.minecraft.getUser().getProfileId());
        if (playerData.currentPos() != null) {
            this.renderStickyIcon(this.playerIcon, playerData.currentPos());
        }
        if (playerData.spawnPos() != null) {
            this.renderStickyIcon(this.spawnIcon, playerData.spawnPos());
        }
    }

    private void renderStickyIcon(IconData iconData, BlockPos pos) {
        double guiScale = this.minecraft.getWindow().getGuiScale();
        NativeImage icon = iconData.img;
        TextureCoordinate texCenter = this.blockToTexture(pos);
        texCenter = new TextureCoordinate(Math.max(0, Math.min(this.texWidth, texCenter.x)), Math.max(0, Math.min(this.texHeight, texCenter.z)));
        int texStartX = texCenter.x - icon.getWidth();
        int texStartZ = texCenter.z - icon.getHeight();
        int rXMin = (int)((double)texStartX + (double)this.getX() * guiScale);
        int rZMin = (int)((double)texStartZ + (double)this.getY() * guiScale);
        int rXMax = rXMin + icon.getWidth() * 2;
        int rZMax = rZMin + icon.getHeight() * 2;
        WorldPreviewClient.renderTexture((AbstractTexture)iconData.texture, rXMin, rZMin, rXMax, rZMax);
    }

    private void biomesChanged() {
        short i;
        Short2LongOpenHashMap tempBiomesSet = new Short2LongOpenHashMap(this.workingVisibleBiomes.length);
        Short2LongOpenHashMap tempStructuresSet = new Short2LongOpenHashMap(this.workingVisibleStructures.length);
        for (i = 0; i < this.workingVisibleBiomes.length; i = (short)((short)(i + 1))) {
            if (this.workingVisibleBiomes[i] <= 0L) continue;
            tempBiomesSet.put(i, this.workingVisibleBiomes[i]);
        }
        for (i = 0; i < this.workingVisibleStructures.length; i = (short)(i + 1)) {
            if (this.workingVisibleStructures[i] <= 0L) continue;
            tempStructuresSet.put(i, this.workingVisibleStructures[i]);
        }
        if (!tempBiomesSet.equals((Object)this.visibleBiomes)) {
            this.dataProvider.onVisibleBiomesChanged((Short2LongMap)tempBiomesSet);
        }
        if (!tempStructuresSet.equals((Object)this.visibleStructures)) {
            this.dataProvider.onVisibleStructuresChanged((Short2LongMap)tempStructuresSet);
        }
        this.visibleBiomes = tempBiomesSet;
        this.visibleStructures = tempStructuresSet;
    }

    private HoverInfo hoveredBiome(double mouseX, double mouseY) {
        if (!this.isHovered || this.workManager.previewStorage() == null) {
            return null;
        }
        int guiScale = (int)this.minecraft.getWindow().getGuiScale();
        BlockPos center = this.center();
        int xMin = center.getX() - this.texWidth / 2 * this.scaleBlockPos - 1;
        int zMin = center.getZ() - this.texHeight / 2 * this.scaleBlockPos - 1;
        int xPos = (int)((mouseX - (double)this.getX()) * (double)guiScale * (double)this.scaleBlockPos);
        int zPos = (int)((mouseY - (double)this.getY()) * (double)guiScale * (double)this.scaleBlockPos);
        int quartX = QuartPos.fromBlock((int)(xMin + xPos));
        int quartY = QuartPos.fromBlock((int)center.getY());
        int quartZ = QuartPos.fromBlock((int)(zMin + zPos));
        short biome = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 0L);
        short height = this.workManager.previewStorage().getRawData4(quartX, 0, quartZ, 2L);
        if (biome < 0) {
            return new HoverInfo(xMin + xPos, center.getY(), zMin + zPos, null, height, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        short temperature = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 9L);
        short humidity = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 10L);
        short continentalness = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 11L);
        short erosion = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 12L);
        short depth = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 13L);
        short weirdness = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 14L);
        if (temperature == Short.MIN_VALUE && humidity == Short.MIN_VALUE && continentalness == Short.MIN_VALUE && erosion == Short.MIN_VALUE && depth == Short.MIN_VALUE && weirdness == Short.MIN_VALUE) {
            return new HoverInfo(xMin + xPos, center.getY(), zMin + zPos, this.dataProvider.biome4Id(biome), height, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        return new HoverInfo(xMin + xPos, center.getY(), zMin + zPos, this.dataProvider.biome4Id(biome), height, (double)temperature / 1.0 / 32767.0, (double)humidity / 1.0 / 32767.0, (double)continentalness / 0.5 / 32767.0, (double)erosion / 1.0 / 32767.0, (double)depth / 0.5 / 32767.0, (double)weirdness / 0.75 / 32767.0, NoiseRouterData.peaksAndValleys((float)Math.min(1.0f, Math.max(-1.0f, (float)weirdness / 0.75f / 32767.0f))));
    }

    private List<StructHoverHelperEntry> hoveredStructures(double mouseX, double mouseY) {
        if (!this.isHovered) {
            return List.of();
        }
        int guiScale = (int)this.minecraft.getWindow().getGuiScale();
        int xTexPos = (int)(mouseX - (double)this.getX()) * guiScale;
        int zTexPos = (int)(mouseY - (double)this.getY()) * guiScale;
        int xGridPos = xTexPos / 64;
        int zGridPos = zTexPos / 64;
        ArrayList<StructHoverHelperEntry> res = new ArrayList<StructHoverHelperEntry>();
        for (int x = xGridPos - 1; x <= xGridPos + 1; ++x) {
            for (int z = zGridPos - 1; z <= zGridPos + 1; ++z) {
                if (x < 0 || x >= this.hoverHelperGridWidth || z < 0 || z >= this.hoverHelperGridHeight) continue;
                StructHoverHelperCell cell = this.hoverHelperGrid[x * this.hoverHelperGridHeight + z];
                for (StructHoverHelperEntry entry : cell.entries) {
                    if (!entry.boundingBox.isInside(xTexPos, 0, zTexPos)) continue;
                    res.add(entry);
                }
            }
        }
        return res;
    }

    private static String nameFormatter(String s) {
        int idx = s.indexOf(58);
        if (idx < 0) {
            return "\u00a7e" + s + "\u00a7r";
        }
        return String.format("\u00a75\u00a7o%s\u00a7r\u00a75:%s\u00a7r", s.substring(0, idx), s.substring(idx + 1));
    }

    private void setTooltipNow(Tooltip tooltip) {
        this.minecraft.screen.setTooltipForNextRenderPass(tooltip, DefaultTooltipPositioner.INSTANCE, true);
    }

    private void updateTooltip(double mouseX, double mouseY) {
        HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
        List<StructHoverHelperEntry> structuresInfos = this.hoveredStructures(mouseX, mouseY);
        if (hoverInfo == null && structuresInfos.isEmpty()) {
            return;
        }
        String blockPosTemplate = "\u00a73X=\u00a7b%d\u00a7r\u00a0\u00a73Y=\u00a7b%d\u00a7r\u00a0\u00a73Z=\u00a7b%d\u00a7r";
        if (!structuresInfos.isEmpty()) {
            PreviewSection.PreviewStruct structure = structuresInfos.getFirst().structure;
            if (this.config.showControls) {
                this.setTooltipNow(Tooltip.create((Component)Component.translatable((String)"world_preview.preview-display.struct.tooltip.controls", (Object[])new Object[]{PreviewDisplay.nameFormatter(this.dataProvider.structure4Id(structure.structureId()).name()), blockPosTemplate.formatted(structure.center().getX(), structure.center().getY(), structure.center().getZ())})));
            } else {
                this.setTooltipNow(Tooltip.create((Component)Component.translatable((String)"world_preview.preview-display.struct.tooltip", (Object[])new Object[]{PreviewDisplay.nameFormatter(this.dataProvider.structure4Id(structure.structureId()).name()), blockPosTemplate.formatted(structure.center().getX(), structure.center().getY(), structure.center().getZ())})));
            }
            return;
        }
        String height = hoverInfo.height > Short.MIN_VALUE ? String.format("\u00a7b%d\u00a7r", hoverInfo.height) : "\u00a77<N/A>\u00a7r";
        String noise = "";
        if (!Double.isNaN(hoverInfo.temperature)) {
            noise = "\n\n\u00a73T=\u00a7b%.2f\u00a7r\u00a0\u00a73H=\u00a7b%.2f\u00a7r\u00a0\u00a73C=\u00a7b%.2f\u00a7r\n\u00a73E=\u00a7b%.2f\u00a7r\u00a0\u00a73D=\u00a7b%.2f\u00a7r\u00a0\u00a73W=\u00a7b%.2f\u00a7r\n\u00a73PV=\u00a7b%.2f\u00a7r".formatted(hoverInfo.temperature, hoverInfo.humidity, hoverInfo.continentalness, hoverInfo.erosion, hoverInfo.depth, hoverInfo.weirdness, hoverInfo.pv);
        }
        if (this.config.showControls) {
            this.setTooltipNow(Tooltip.create((Component)Component.translatable((String)"world_preview.preview-display.tooltip.controls", (Object[])new Object[]{PreviewDisplay.nameFormatter(hoverInfo.entry == null ? "<N/A>" : hoverInfo.entry.name()), blockPosTemplate.formatted(hoverInfo.blockX, hoverInfo.blockY, hoverInfo.blockZ), height, noise})));
        } else {
            this.setTooltipNow(Tooltip.create((Component)Component.translatable((String)"world_preview.preview-display.tooltip", (Object[])new Object[]{PreviewDisplay.nameFormatter(hoverInfo.entry == null ? "<N/A>" : hoverInfo.entry.name()), blockPosTemplate.formatted(hoverInfo.blockX, hoverInfo.blockY, hoverInfo.blockZ), height, noise})));
        }
    }

    public void playDownSound(SoundManager handler) {
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.minecraft.screen != null) {
            this.minecraft.screen.setFocused((GuiEventListener)this);
        }
        this.clicked = true;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        double guiScale = this.minecraft.getWindow().getGuiScale();
        this.totalDragX -= dragX * guiScale * (double)this.scaleBlockPos;
        this.totalDragZ -= dragY * guiScale * (double)this.scaleBlockPos;
    }

    public void onRelease(double mouseX, double mouseY) {
        if (!this.clicked) {
            return;
        }
        this.clicked = false;
        if (Math.abs(this.totalDragX) <= 4.0 && Math.abs(this.totalDragZ) <= 4.0) {
            HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
            if (hoverInfo == null || hoverInfo.entry == null) {
                return;
            }
            super.playDownSound(this.minecraft.getSoundManager());
            if (this.selectedBiomeId == hoverInfo.entry.id()) {
                this.dataProvider.onBiomeVisuallySelected(null);
            } else {
                this.dataProvider.onBiomeVisuallySelected(hoverInfo.entry);
            }
        }
        this.renderSettings.setCenter(this.center());
        this.totalDragX = 0.0;
        this.totalDragZ = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        PreviewDisplayDataProvider previewDisplayDataProvider = this.dataProvider;
        synchronized (previewDisplayDataProvider) {
            if (this.dataProvider.isUpdating()) {
                return true;
            }
            if (deltaX + deltaY > 0.0) {
                this.renderSettings.decrementY();
            } else if (deltaX + deltaY < 0.0) {
                this.renderSettings.incrementY();
            }
            return true;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.clicked(mouseX, mouseY) && button == 1) {
            this.playDownSound(this.minecraft.getSoundManager());
            HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
            if (hoverInfo == null) {
                return true;
            }
            String coordinates = String.format("%s %s %s", hoverInfo.blockX, hoverInfo.height == Short.MIN_VALUE ? "~" : Short.valueOf(hoverInfo.height), hoverInfo.blockZ);
            this.minecraft.keyboardHandler.setClipboard(coordinates);
            this.coordinatesCopiedTime = Instant.now();
            this.coordinatesCopiedMsg = Component.translatable((String)"world_preview.preview-display.coordinates.copied", (Object[])new Object[]{coordinates});
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private static int textureColor(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig & 0xFF;
        return R | G << 8 | B << 16 | 0xFF000000;
    }

    private static int highlightColor(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig & 0xFF;
        int diff = (R + G + B) / 3 > 200 ? -100 : 100;
        R += diff;
        G += diff;
        B += diff;
        R = Math.max(Math.min(R, 255), 0);
        G = Math.max(Math.min(G, 255), 0);
        B = Math.max(Math.min(B, 255), 0);
        return 0xFF000000 | R << 16 | G << 8 | B;
    }

    private static int grayScale(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig & 0xFF;
        int gray = Math.max(32, Math.min(224, (R + G + B) / 3));
        return 0xFF000000 | gray << 16 | gray << 8 | gray;
    }

    public void setSelectedBiomeId(short biomeId) {
        this.selectedBiomeId = biomeId;
    }

    public void setHighlightCaves(boolean highlightCaves) {
        this.highlightCaves = highlightCaves;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private record IconData(@NotNull NativeImage img, @NotNull DynamicTexture texture) {
        public void close() {
            this.texture.close();
            this.img.close();
        }
    }

    private record StructHoverHelperCell(List<StructHoverHelperEntry> entries) {
    }

    private record TextureCoordinate(int x, int z) {
    }

    private record RenderHelper(PreviewSection dataSection, PreviewSection structureSection, PreviewSection.AccessData accessData, int sectionStartTexX, int sectionStartTexZ) {
    }

    private record StructHoverHelperEntry(BoundingBox boundingBox, PreviewSection.PreviewStruct structure) {
    }

    private record HoverInfo(int blockX, int blockY, int blockZ, BiomesList.BiomeEntry entry, short height, double temperature, double humidity, double continentalness, double erosion, double depth, double weirdness, double pv) {
    }
}

