/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.client.sound.EntityRecordSoundInstance;
import gg.moonflower.etched.common.component.AlbumCoverComponent;
import gg.moonflower.etched.common.component.MusicTrackComponent;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.core.extension.JukeboxSongExt;
import gg.moonflower.etched.core.registry.EtchedComponents;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.CommonLevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PlayableRecord {
    private static final Component ALBUM = Component.translatable((String)"item.etched.etched_music_disc.album").withStyle(ChatFormatting.DARK_GRAY);

    private PlayableRecord() {
    }

    public static boolean isPlayableRecord(ItemStack stack) {
        return stack.has(EtchedComponents.ALBUM_COVER) || stack.has(EtchedComponents.MUSIC) || stack.has(DataComponents.JUKEBOX_PLAYABLE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canShowMessage(double x, double y, double z) {
        LocalPlayer player = Minecraft.getInstance().player;
        return player == null || player.distanceToSqr(x, y, z) <= 4096.0;
    }

    public static void playEntityRecord(Entity entity, ItemStack record, boolean restart) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new ClientboundPlayEntityMusicPacket(record, entity, restart), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void stopEntityRecord(Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new ClientboundPlayEntityMusicPacket(entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static List<TrackData> getTracks(HolderLookup.Provider registries, ItemStack stack) {
        AlbumCoverComponent albumCover;
        MusicTrackComponent music;
        if (stack.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TrackData> tracks = new ArrayList<TrackData>();
        Optional optional = JukeboxSong.fromStack((HolderLookup.Provider)registries, (ItemStack)stack);
        if (optional.isPresent()) {
            JukeboxSongExt song = (JukeboxSongExt)((Holder)optional.get()).value();
            tracks.addAll(song.veil$tracks());
        }
        if ((music = (MusicTrackComponent)stack.get(EtchedComponents.MUSIC)) != null) {
            tracks.addAll(music.tracks());
        }
        if ((albumCover = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER)) != null) {
            for (ItemStack record : albumCover.getItems()) {
                tracks.addAll(PlayableRecord.getTracks(registries, record));
            }
        }
        return tracks;
    }

    public static int getTrackCount(HolderLookup.Provider registries, ItemStack stack) {
        AlbumCoverComponent albumCover;
        MusicTrackComponent music;
        if (stack.isEmpty()) {
            return 0;
        }
        int tracks = 0;
        Optional optional = JukeboxSong.fromStack((HolderLookup.Provider)registries, (ItemStack)stack);
        if (optional.isPresent()) {
            JukeboxSongExt song = (JukeboxSongExt)((Holder)optional.get()).value();
            tracks += song.veil$tracks().size();
        }
        if ((music = (MusicTrackComponent)stack.get(EtchedComponents.MUSIC)) != null) {
            tracks += music.tracks().size();
        }
        if ((albumCover = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER)) != null) {
            for (ItemStack record : albumCover.getItems()) {
                tracks += PlayableRecord.getTrackCount(registries, record);
            }
        }
        return tracks;
    }

    public static Optional<TrackData> getAlbum(ItemStack stack) {
        TrackData album = (TrackData)stack.get(EtchedComponents.ALBUM);
        if (album != null) {
            return Optional.of(album);
        }
        MusicTrackComponent music = (MusicTrackComponent)stack.get(EtchedComponents.MUSIC);
        if (music != null && !music.tracks().isEmpty()) {
            return Optional.of(music.tracks().getFirst());
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<SoundInstance> createEntitySound(ItemStack stack, Entity entity, int track) {
        return PlayableRecord.createEntitySound(stack, entity, track, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<SoundInstance> createEntitySound(ItemStack stack, Entity entity, int track, int attenuationDistance) {
        AlbumCoverComponent albumCover;
        MusicTrackComponent music;
        if (track < 0) {
            return Optional.empty();
        }
        Optional optional = JukeboxSong.fromStack((HolderLookup.Provider)entity.registryAccess(), (ItemStack)stack);
        if (optional.isPresent()) {
            if (track == 0) {
                JukeboxSong song = (JukeboxSong)((Holder)optional.get()).value();
                if (entity.level().getBlockState(entity.blockPosition().above()).isAir() && PlayableRecord.canShowMessage(entity.getX(), entity.getY(), entity.getZ())) {
                    Minecraft.getInstance().gui.setNowPlaying(song.description());
                }
                return Optional.of(new EntityRecordSoundInstance((SoundEvent)song.soundEvent().value(), entity));
            }
            --track;
        }
        if ((music = (MusicTrackComponent)stack.get(EtchedComponents.MUSIC)) != null) {
            List<TrackData> tracks = music.tracks();
            if (track < tracks.size()) {
                TrackData trackData = tracks.get(track);
                return Optional.ofNullable(SoundTracker.getEtchedRecord(trackData.url(), trackData.getDisplayName(), entity, attenuationDistance, false));
            }
            track -= tracks.size();
        }
        if ((albumCover = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER)) != null) {
            for (ItemStack record : albumCover.getItems()) {
                Optional<SoundInstance> entitySound = PlayableRecord.createEntitySound(record, entity, track, attenuationDistance);
                if (entitySound.isPresent()) {
                    return entitySound;
                }
                track -= PlayableRecord.getTrackCount((HolderLookup.Provider)entity.registryAccess(), record);
            }
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<SoundInstance> createBlockSound(ItemStack stack, CommonLevelAccessor level, BlockPos pos, int track) {
        return PlayableRecord.createBlockSound(stack, level, pos, track, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<SoundInstance> createBlockSound(ItemStack stack, CommonLevelAccessor level, BlockPos pos, int track, int attenuationDistance) {
        AlbumCoverComponent albumCover;
        MusicTrackComponent music;
        if (track < 0) {
            return Optional.empty();
        }
        Optional optional = JukeboxSong.fromStack((HolderLookup.Provider)level.registryAccess(), (ItemStack)stack);
        if (optional.isPresent()) {
            if (track == 0) {
                JukeboxSong song = (JukeboxSong)((Holder)optional.get()).value();
                return Optional.ofNullable(SoundTracker.getEtchedRecord(((SoundEvent)song.soundEvent().value()).getLocation().toString(), song.description(), level, pos, attenuationDistance, AudioSource.AudioFileType.FILE));
            }
            --track;
        }
        if ((music = (MusicTrackComponent)stack.get(EtchedComponents.MUSIC)) != null) {
            List<TrackData> tracks = music.tracks();
            if (track < tracks.size()) {
                TrackData trackData = tracks.get(track);
                String url = trackData.url();
                return Optional.ofNullable(SoundTracker.getEtchedRecord(url, trackData.getDisplayName(), level, pos, attenuationDistance, AudioSource.AudioFileType.FILE));
            }
            track -= tracks.size();
        }
        if ((albumCover = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER)) != null) {
            for (ItemStack record : albumCover.getItems()) {
                Optional<SoundInstance> entitySound = PlayableRecord.createBlockSound(record, level, pos, track, attenuationDistance);
                if (entitySound.isPresent()) {
                    return entitySound;
                }
                track -= PlayableRecord.getTrackCount((HolderLookup.Provider)level.registryAccess(), record);
            }
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static CompletableFuture<AlbumCover> getAlbumCover(ItemStack stack, Proxy proxy, ResourceManager resourceManager) {
        Optional<TrackData> album = PlayableRecord.getAlbum(stack);
        if (album.isPresent()) {
            return SoundSourceManager.resolveAlbumCover(album.get().url(), null, proxy, resourceManager);
        }
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (resourceManager.getResource(key.withPath("models/item/etched_album_cover/" + key.getPath() + ".json")).isPresent()) {
            return CompletableFuture.completedFuture(AlbumCover.of(key.withPath("item/etched_album_cover/" + key.getPath())));
        }
        return CompletableFuture.completedFuture(AlbumCover.EMPTY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addToTooltip(ItemStack stack, Item.TooltipContext context, Consumer<Component> adder) {
        PlayableRecord.getAlbum(stack).ifPresent(track -> {
            boolean album = PlayableRecord.getTrackCount(context.registries(), stack) > 1;
            adder.accept((Component)track.getDisplayName().copy().withStyle(ChatFormatting.GRAY));
            SoundSourceManager.getBrandText(track.url()).map(component -> {
                if (album) {
                    return Component.literal((String)"  ").append(component).append(" ").append(ALBUM);
                }
                return Component.literal((String)"  ").append(component);
            }).ifPresentOrElse(adder, () -> {
                if (album) {
                    adder.accept(ALBUM);
                }
            });
        });
    }
}

