/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import org.lwjgl.BufferUtils;

public class MonoWrapper
implements AudioStream {
    private final AudioStream source;
    private final AudioFormat format;
    private final int sourceChannels;

    public MonoWrapper(AudioStream source) {
        this.source = source;
        AudioFormat sourceFormat = source.getFormat();
        this.sourceChannels = sourceFormat.getChannels();
        this.format = this.sourceChannels != 1 ? new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), 1, sourceFormat.getFrameSize() / sourceFormat.getChannels(), sourceFormat.getFrameRate(), sourceFormat.isBigEndian()) : sourceFormat;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public ByteBuffer read(int amount) throws IOException {
        ByteBuffer parent = this.source.read(amount * this.sourceChannels);
        if (this.sourceChannels == 1) {
            return parent;
        }
        ByteBuffer modified = BufferUtils.createByteBuffer((int)(parent.limit() / this.sourceChannels));
        int step = this.format.getSampleSizeInBits() / 8;
        for (int j = 0; j < parent.limit(); j += step * 2) {
            for (int l = 0; l < step; ++l) {
                modified.put(parent.get(j + l));
            }
        }
        modified.rewind();
        return modified;
    }

    public void close() throws IOException {
        this.source.close();
    }
}

