/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.blockentity;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class AlbumJukeboxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    private int playingIndex = -1;
    private int track = 0;
    private ItemStack playingStack = ItemStack.EMPTY;
    private boolean loaded;

    public AlbumJukeboxBlockEntity(BlockPos pos, BlockState state) {
        super(EtchedBlocks.ALBUM_JUKEBOX_BE.get(), pos, state);
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, AlbumJukeboxBlockEntity entity) {
        if (!entity.loaded) {
            entity.loaded = true;
            SoundTracker.playAlbum(entity, state, (CommonLevelAccessor)level, pos, false);
        }
        if (entity.isPlaying()) {
            AABB range = new AABB(pos).inflate(3.45);
            List livingEntities = level.getEntitiesOfClass(LivingEntity.class, range);
            livingEntities.forEach(living -> living.setRecordPlayingNearby(pos, true));
        }
    }

    private void updateState() {
        if (this.level != null) {
            boolean hasRecord;
            boolean hasItem = false;
            for (ItemStack stack : this.getItems()) {
                if (stack == ItemStack.EMPTY) continue;
                hasItem = true;
                break;
            }
            if (hasItem != (hasRecord = ((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)AlbumJukeboxBlock.HAS_RECORD)).booleanValue())) {
                this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)AlbumJukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(hasItem)), 3);
                this.setChanged();
            }
        }
    }

    private void updatePlaying() {
        if (this.level == null) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
        if (this.loaded) {
            SoundTracker.playAlbum(this, this.getBlockState(), (CommonLevelAccessor)this.level, this.getBlockPos(), false);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int[] getSlotsForFace(Direction direction) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return PlayableRecord.isPlayableRecord(stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getContainerSize() {
        return 9;
    }

    public ItemStack removeItem(int index, int amount) {
        ItemStack stack = super.removeItem(index, amount);
        this.updateState();
        if (!stack.isEmpty()) {
            this.updatePlaying();
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = super.removeItemNoUpdate(index);
        this.updateState();
        if (!stack.isEmpty()) {
            this.updatePlaying();
        }
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        super.setItem(index, stack);
        this.updateState();
        this.updatePlaying();
    }

    public void clearContent() {
        super.clearContent();
        this.updateState();
        this.updatePlaying();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.etched.album_jukebox");
    }

    protected AbstractContainerMenu createMenu(int menuId, Inventory inventory) {
        return new AlbumJukeboxMenu(menuId, inventory, (Container)this, this.getBlockPos());
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getPlayingIndex() {
        return this.playingIndex;
    }

    public int getTrack() {
        return this.track;
    }

    public boolean setPlayingIndex(int playingIndex, int track) {
        this.playingIndex = playingIndex;
        this.track = track;
        if (this.recalculatePlayingIndex(false)) {
            int tracks = PlayableRecord.getTrackCount((HolderLookup.Provider)this.level.registryAccess(), this.playingStack);
            if (this.track >= tracks) {
                this.track = 0;
            }
            return true;
        }
        return false;
    }

    public void stopPlaying() {
        this.playingIndex = -1;
        this.track = 0;
        this.playingStack = ItemStack.EMPTY;
    }

    public void previous() {
        if (this.track > 0) {
            --this.track;
        } else {
            --this.playingIndex;
            if (this.playingIndex < 0) {
                this.playingIndex = this.getContainerSize() - 1;
            }
            this.nextPlayingIndex(true);
            this.track = Math.max(0, this.playingIndex < 0 || this.playingIndex >= this.getContainerSize() ? 0 : PlayableRecord.getTrackCount((HolderLookup.Provider)this.level.registryAccess(), this.getItem(this.playingIndex)) - 1);
            this.playingStack = ItemStack.EMPTY;
        }
    }

    public void next() {
        int tracks;
        int n = tracks = this.playingIndex < 0 || this.playingIndex >= this.getContainerSize() ? 1 : PlayableRecord.getTrackCount((HolderLookup.Provider)this.level.registryAccess(), this.getItem(this.playingIndex));
        if (this.track < tracks - 1) {
            ++this.track;
        } else {
            ++this.playingIndex;
            this.playingIndex %= this.getContainerSize();
            this.nextPlayingIndex(false);
            this.track = 0;
            this.playingStack = ItemStack.EMPTY;
        }
    }

    public void nextPlayingIndex(boolean reverse) {
        boolean wrap = false;
        this.playingIndex = Mth.clamp((int)this.playingIndex, (int)0, (int)(this.getContainerSize() - 1));
        while (!PlayableRecord.isPlayableRecord(this.getItem(this.playingIndex))) {
            if (reverse) {
                --this.playingIndex;
                if (this.playingIndex >= 0) continue;
                this.playingIndex = this.getContainerSize() - 1;
                if (wrap) {
                    this.playingIndex = -1;
                    this.track = 0;
                    this.playingStack = ItemStack.EMPTY;
                    return;
                }
                wrap = true;
                continue;
            }
            ++this.playingIndex;
            if (this.playingIndex < this.getContainerSize()) continue;
            this.playingIndex = 0;
            if (wrap) {
                this.playingIndex = -1;
                this.track = 0;
                this.playingStack = ItemStack.EMPTY;
                return;
            }
            wrap = true;
        }
        this.playingStack = this.getItem(this.playingIndex).copy();
    }

    public boolean recalculatePlayingIndex(boolean reverse) {
        if (this.isEmpty()) {
            if (this.playingIndex == -1) {
                return false;
            }
            this.playingIndex = -1;
            this.track = 0;
            return true;
        }
        int oldIndex = this.playingIndex;
        ItemStack oldStack = this.playingStack.copy();
        this.nextPlayingIndex(reverse);
        if (oldIndex != this.playingIndex || !ItemStack.matches((ItemStack)oldStack, (ItemStack)this.playingStack)) {
            if (!reverse) {
                this.track = 0;
                return true;
            }
            if (this.playingIndex < 0 || this.playingIndex >= this.getContainerSize()) {
                this.track = 0;
                return true;
            }
            this.track = Math.max(0, PlayableRecord.getTrackCount((HolderLookup.Provider)this.level.registryAccess(), this.getItem(this.playingIndex)) - 1);
            return true;
        }
        return false;
    }

    public boolean isPlaying() {
        BlockState state = this.getBlockState();
        return (!state.hasProperty((Property)AlbumJukeboxBlock.POWERED) || (Boolean)state.getValue((Property)AlbumJukeboxBlock.POWERED) == false) && !this.isEmpty();
    }
}

