/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.etched.core.Etched;
import java.util.Locale;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record DiscAppearanceComponent(LabelPattern pattern, int discColor, int labelPrimaryColor, int labelSecondaryColor) {
    private final int discColor;
    private final int labelPrimaryColor;
    private final int labelSecondaryColor;
    public static final DiscAppearanceComponent DEFAULT = new DiscAppearanceComponent(LabelPattern.FLAT, 0x515151, 0xFFFFFF, 0xFFFFFF);
    public static final Codec<DiscAppearanceComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LabelPattern.CODEC.fieldOf("pattern").forGetter(DiscAppearanceComponent::pattern), (App)Codec.INT.fieldOf("discColor").forGetter(DiscAppearanceComponent::discColor), (App)Codec.INT.fieldOf("labelPrimaryColor").forGetter(DiscAppearanceComponent::labelPrimaryColor), (App)Codec.INT.fieldOf("labelSecondaryColor").forGetter(DiscAppearanceComponent::labelSecondaryColor)).apply((Applicative)instance, DiscAppearanceComponent::new));
    public static final StreamCodec<FriendlyByteBuf, DiscAppearanceComponent> STREAM_CODEC = StreamCodec.of((buffer, value) -> {
        buffer.writeEnum((Enum)value.pattern);
        buffer.writeInt(value.discColor);
        if (value.pattern.isColorable()) {
            buffer.writeInt(value.labelPrimaryColor);
            if (value.pattern.isComplex()) {
                buffer.writeInt(value.labelSecondaryColor);
            }
        }
    }, buffer -> {
        LabelPattern pattern = (LabelPattern)buffer.readEnum(LabelPattern.class);
        int discColor = buffer.readInt();
        int labelPrimaryColor = -1;
        int labelSecondaryColor = -1;
        if (pattern.isColorable()) {
            labelPrimaryColor = buffer.readInt();
            if (pattern.isComplex()) {
                labelSecondaryColor = buffer.readInt();
            }
        }
        return new DiscAppearanceComponent(pattern, discColor, labelPrimaryColor, labelSecondaryColor);
    });

    public DiscAppearanceComponent(LabelPattern pattern, int discColor, int labelPrimaryColor, int labelSecondaryColor) {
        this.pattern = pattern;
        this.discColor = 0xFFFFFF & discColor;
        this.labelPrimaryColor = 0xFFFFFF & labelPrimaryColor;
        this.labelSecondaryColor = 0xFFFFFF & labelSecondaryColor;
    }

    public int discColor() {
        return 0xFF000000 | this.discColor;
    }

    public int labelPrimaryColor() {
        return 0xFF000000 | this.labelPrimaryColor;
    }

    public int labelSecondaryColor() {
        return 0xFF000000 | this.labelSecondaryColor;
    }

    public static enum LabelPattern {
        FLAT,
        CROSS,
        EYE,
        PARALLEL,
        STAR,
        GOLD(true);

        public static final Codec<LabelPattern> CODEC;
        private final boolean simple;
        private final Pair<ResourceLocation, ResourceLocation> textures;

        private LabelPattern() {
            this(false);
        }

        private LabelPattern(boolean simple) {
            this.simple = simple;
            String name = this.name().toLowerCase(Locale.ROOT);
            this.textures = Pair.of((Object)Etched.etchedPath("textures/item/" + name + "_label" + (simple ? "" : "_top") + ".png"), (Object)Etched.etchedPath("textures/item/" + name + "_label" + (simple ? "" : "_bottom") + ".png"));
        }

        public Pair<ResourceLocation, ResourceLocation> getTextures() {
            return this.textures;
        }

        public boolean isComplex() {
            return !this.simple;
        }

        public boolean isColorable() {
            return this != GOLD;
        }

        static {
            CODEC = Codec.STRING.flatXmap(name -> {
                for (LabelPattern value : LabelPattern.values()) {
                    if (!value.name().equalsIgnoreCase((String)name)) continue;
                    return DataResult.success((Object)((Object)value));
                }
                return DataResult.error(() -> "Unknown Label Pattern: " + name.toLowerCase(Locale.ROOT));
            }, pattern -> DataResult.success((Object)pattern.name().toLowerCase(Locale.ROOT)));
        }
    }
}

