/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.common.entity.MinecartJukebox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class MinecartJukeboxItem
extends Item {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel serverlevel = source.level();
            Vec3 vec3 = source.center();
            double d0 = vec3.x() + (double)direction.getStepX() * 1.125;
            double d1 = Math.floor(vec3.y()) + (double)direction.getStepY();
            double d2 = vec3.z() + (double)direction.getStepZ() * 1.125;
            BlockPos blockpos = source.pos().relative(direction);
            BlockState blockstate = serverlevel.getBlockState(blockpos);
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock railBlock = (BaseRailBlock)block;
                v0 = railBlock.getRailDirection(blockstate, (BlockGetter)serverlevel, blockpos, null);
            } else {
                v0 = railshape = RailShape.NORTH_SOUTH;
            }
            if (blockstate.is(BlockTags.RAILS)) {
                d3 = railshape.isAscending() ? 0.6 : 0.1;
            } else {
                RailShape railShape;
                if (!blockstate.isAir() || !serverlevel.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
                BlockState blockstate1 = serverlevel.getBlockState(blockpos.below());
                Block block2 = blockstate1.getBlock();
                if (block2 instanceof BaseRailBlock) {
                    BaseRailBlock railBlock = (BaseRailBlock)block2;
                    railShape = railBlock.getRailDirection(blockstate1, (BlockGetter)serverlevel, blockpos.below(), null);
                } else {
                    railShape = RailShape.NORTH_SOUTH;
                }
                RailShape railshape1 = railShape;
                d3 = direction != Direction.DOWN && railshape1.isAscending() ? -0.4 : -0.9;
            }
            MinecartJukebox jukeboxMinecart = new MinecartJukebox((Level)serverlevel, d0, d1 + d3, d2);
            serverlevel.addFreshEntity((Entity)jukeboxMinecart);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    public MinecartJukeboxItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(pos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            RailShape railShape;
            ServerLevel serverlevel = (ServerLevel)level;
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock railBlock = (BaseRailBlock)block;
                railShape = railBlock.getRailDirection(blockstate, (BlockGetter)level, pos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double d0 = 0.0;
            if (railshape.isAscending()) {
                d0 = 0.5;
            }
            MinecartJukebox jukeboxMinecart = new MinecartJukebox(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.0625 + d0, (double)pos.getZ() + 0.5);
            serverlevel.addFreshEntity((Entity)jukeboxMinecart);
            serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)serverlevel.getBlockState(pos.below())));
        }
        itemstack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

