/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.menu.UrlMenu;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayBlockMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.common.network.play.SetUrlPacket;
import gg.moonflower.etched.core.mixin.client.render.LevelRendererAccessor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedClientPlayPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handlePlayBlockMusicPacket(ClientboundPlayBlockMusicPacket pkt, IPayloadContext ctx) {
        List<TrackData> tracks;
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        BlockPos pos = pkt.pos();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)client.levelRenderer).getPlayingJukeboxSongs();
        SoundInstance soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            client.getSoundManager().stop(soundInstance);
            playingRecords.remove(pos);
        }
        if ((tracks = pkt.tracks((HolderLookup.Provider)client.getConnection().registryAccess())).isEmpty()) {
            return;
        }
        SoundTracker.playBlockRecord(pos, (TrackData[])tracks.toArray(TrackData[]::new), 0);
    }

    public static void handlePlayEntityMusicPacket(ClientboundPlayEntityMusicPacket pkt, IPayloadContext ctx) {
        Minecraft client = Minecraft.getInstance();
        ClientLevel level = client.level;
        if (level == null) {
            return;
        }
        int entityId = pkt.getEntityId();
        SoundInstance soundInstance = SoundTracker.getEntitySound(entityId);
        if (soundInstance != null) {
            if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.RESTART && client.getSoundManager().isActive(soundInstance)) {
                return;
            }
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            SoundTracker.setEntitySound(entityId, null);
        }
        if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.STOP) {
            return;
        }
        Entity entity = level.getEntity(entityId);
        if (entity == null) {
            LOGGER.error("Server sent sound for nonexistent entity: {}", (Object)entityId);
            return;
        }
        ItemStack record = pkt.getRecord();
        if (!PlayableRecord.isPlayableRecord(record)) {
            LOGGER.error("Server sent invalid music disc: {}", (Object)record);
            return;
        }
        Optional<SoundInstance> sound = PlayableRecord.createEntitySound(record, entity, 0);
        if (sound.isEmpty()) {
            LOGGER.error("Server sent invalid music disc: {}", (Object)record);
            return;
        }
        StopListeningSound entitySound = StopListeningSound.create(sound.get(), () -> client.tell(() -> {
            SoundTracker.setEntitySound(entityId, null);
            SoundTracker.playEntityRecord(record, entityId, 1, false);
        }));
        SoundTracker.setEntitySound(entityId, entitySound);
    }

    public static void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt, IPayloadContext ctx) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof EtchingScreen) {
            EtchingScreen screen2 = (EtchingScreen)screen;
            screen2.setReason(pkt.exception());
        }
    }

    public static void handleSetUrl(SetUrlPacket pkt, IPayloadContext ctx) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof UrlMenu) {
            UrlMenu screen2 = (UrlMenu)screen;
            screen2.setUrl(pkt.url());
        }
    }

    public static void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, IPayloadContext ctx) {
        Screen screen;
        Minecraft client = Minecraft.getInstance();
        if (client.level != null && (screen = client.screen) instanceof AlbumJukeboxScreen) {
            AlbumJukeboxScreen screen2 = (AlbumJukeboxScreen)screen;
            BlockPos pos = ((AlbumJukeboxMenu)screen2.getMenu()).getPos();
            if (((AlbumJukeboxMenu)screen2.getMenu()).setPlayingTrack((Level)client.level, pkt)) {
                AlbumJukeboxBlockEntity entity = (AlbumJukeboxBlockEntity)Objects.requireNonNull(client.level.getBlockEntity(pos));
                SoundTracker.playAlbum(entity, entity.getBlockState(), (CommonLevelAccessor)client.level, pos, true);
            }
        }
    }
}

