/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.AbstractBlockDirectional;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.ShingleSlabShapeType;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeBuilder;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShingleSlabBlock
extends AbstractBlockDirectional<ShingleSlabBlock>
implements SimpleWaterloggedBlock,
IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final MapCodec<ShingleSlabBlock> CODEC = ShingleSlabBlock.simpleCodec(ShingleSlabBlock::new);
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(ResourceLocation.withDefaultNamespace((String)"block/oak_planks"), ModTags.SHINGLES_ROOF, Blocks.OAK_PLANKS)).add((Object)new SimpleRetexturableComponent(ResourceLocation.withDefaultNamespace((String)"block/dark_oak_planks"), ModTags.SHINGLES_SUPPORT, Blocks.DARK_OAK_PLANKS)).build();
    public static final EnumProperty<ShingleSlabShapeType> SHAPE = EnumProperty.create((String)"shape", ShingleSlabShapeType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private static final int FOUR_CONNECTIONS = 4;
    private static final int THREE_CONNECTIONS = 3;
    private static final int TWO_CONNECTIONS = 2;
    private static final int ONE_CONNECTION = 1;
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public ShingleSlabBlock() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f, 1.0f));
    }

    public ShingleSlabBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<ShingleSlabBlock> codec() {
        return CODEC;
    }

    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction HORIZONTAL_FACING, @NotNull BlockState HORIZONTAL_FACINGState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos HORIZONTAL_FACINGPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return ShingleSlabBlock.getSlabShape(stateIn, worldIn, currentPos);
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        @NotNull Direction facing = context.getPlayer() == null ? Direction.NORTH : Direction.fromYRot((double)context.getPlayer().getYRot());
        return ShingleSlabBlock.getSlabShape((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.9, (double)7.9, (double)15.9);
    }

    private static BlockState getSlabShape(@NotNull BlockState state, @NotNull LevelAccessor world, @NotNull BlockPos position) {
        BlockState shapeState;
        boolean north = world.getBlockState(position.north()).getBlock() instanceof ShingleSlabBlock;
        boolean south = world.getBlockState(position.south()).getBlock() instanceof ShingleSlabBlock;
        boolean east = world.getBlockState(position.east()).getBlock() instanceof ShingleSlabBlock;
        boolean west = world.getBlockState(position.west()).getBlock() instanceof ShingleSlabBlock;
        boolean[] connectors = new boolean[]{north, south, east, west};
        int amount = 0;
        for (boolean check : connectors) {
            if (!check) continue;
            ++amount;
        }
        if (amount == 1) {
            shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.ONE_WAY));
            if (north) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (south) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.SOUTH);
            }
            if (east) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.EAST);
            }
            if (west) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.WEST);
            }
        }
        if (amount == 2) {
            if (north && east) {
                shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.WEST);
            }
            if (north && west) {
                shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.SOUTH);
            }
            if (south && east) {
                shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (south && west) {
                shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.EAST);
            }
            if (north && south) {
                shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (east && west) {
                shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.EAST);
            }
        }
        if (amount == 3) {
            shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.THREE_WAY));
            if (north && east && west) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (south && east && west) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.SOUTH);
            }
            if (east && north && south) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.EAST);
            }
            if (west && north && south) {
                return (BlockState)shapeState.setValue((Property)FACING, (Comparable)Direction.WEST);
            }
        }
        if (amount == 4) {
            shapeState = (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.FOUR_WAY));
            return shapeState;
        }
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TOP));
    }

    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return type == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack(world.getBlockEntity(pos), (HolderLookup.Provider)world.registryAccess(), new Property[0]);
    }

    @Override
    public void buildRecipes(RecipeOutput recipeOutput) {
        new ArchitectsCutterRecipeBuilder(this, RecipeCategory.BUILDING_BLOCKS).count(COMPONENTS.size() * 2).save(recipeOutput);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getDestroyProgress(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(0);
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        this.fillDOItemCategory((Block)this, items, this.fillItemGroupCache);
    }
}

