/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.utils;

import com.ldtteam.domumornamentum.client.model.utils.ModelSpriteQuadTransformerData;
import com.ldtteam.domumornamentum.util.SingleBlockLevelReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ModelSpriteQuadTransformer
implements IQuadTransformer {
    private final ModelSpriteQuadTransformerData target;

    public static IQuadTransformer create(ModelSpriteQuadTransformerData target) {
        return new ModelSpriteQuadTransformer(target);
    }

    private ModelSpriteQuadTransformer(ModelSpriteQuadTransformerData target) {
        this.target = target;
    }

    public void processInPlace(BakedQuad quad) {
        float minU = quad.getSprite().getU0();
        float uDelta = quad.getSprite().getU1() - minU;
        float minV = quad.getSprite().getV0();
        float vDelta = quad.getSprite().getV1() - minV;
        quad.sprite = this.target.quad().sprite;
        for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
            float[] uv = new float[2];
            int offset = vertexIndex * STRIDE + UV0;
            uv[0] = Float.intBitsToFloat(quad.getVertices()[offset]);
            uv[1] = Float.intBitsToFloat(quad.getVertices()[offset + 1]);
            float u = (uv[0] - minU) / uDelta;
            float v = (uv[1] - minV) / vDelta;
            float newU = this.target.quad().sprite.getU(u);
            float newV = this.target.quad().sprite.getV(v);
            quad.getVertices()[offset] = Float.floatToRawIntBits(newU);
            quad.getVertices()[offset + 1] = Float.floatToRawIntBits(newV);
        }
        int color = this.getColorFor(this.target.state());
        int tint = this.target.quad().tintIndex;
        int n = color = tint != -1 ? color : -1;
        if (0 <= tint && tint <= 255) {
            color = -1;
            tint = Block.getId((BlockState)this.target.state()) << 8 | tint;
        } else {
            tint = -1;
        }
        if (color != -1) {
            QuadTransformers.applyingColor((int)color).processInPlace(quad);
        }
        if (tint != -1) {
            quad.tintIndex = tint;
        }
    }

    private int getColorFor(BlockState state) {
        ItemStack target;
        Fluid fluid = state.getFluidState().getType();
        int out = fluid != Fluids.EMPTY ? IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(new FluidStack(fluid, 1)) : ((target = ModelSpriteQuadTransformer.getItemStackFromBlockState(state)).isEmpty() ? 0xFFFFFF : Minecraft.getInstance().getItemColors().getColor(target, 0));
        return out;
    }

    private static ItemStack getItemStackFromBlockState(BlockState state) {
        if (state.getBlock() instanceof LiquidBlock) {
            return new ItemStack((ItemLike)state.getFluidState().getType().getBucket());
        }
        Item item = ModelSpriteQuadTransformer.getItem(state);
        if (item != Items.AIR && item != null) {
            return new ItemStack((ItemLike)item, 1);
        }
        return new ItemStack((ItemLike)state.getBlock(), 1);
    }

    private static Item getItem(@NotNull BlockState state) {
        Block block = state.getBlock();
        if (block.equals(Blocks.LAVA)) {
            return Items.LAVA_BUCKET;
        }
        if (block instanceof CropBlock) {
            ItemStack stack = block.getCloneItemStack((LevelReader)new SingleBlockLevelReader(state), BlockPos.ZERO, state);
            if (!stack.isEmpty()) {
                return stack.getItem();
            }
            return Items.WHEAT_SEEDS;
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return Blocks.DIRT.asItem();
        }
        if (block instanceof FireBlock) {
            return Items.FLINT_AND_STEEL;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.FLOWER_POT;
        }
        if (block == Blocks.BAMBOO_SAPLING) {
            return Items.BAMBOO;
        }
        return block.asItem();
    }
}

