/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.post;

import com.ldtteam.domumornamentum.block.AbstractPostBlock;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PostBlock;
import com.ldtteam.domumornamentum.block.types.PostType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import com.ldtteam.domumornamentum.util.Constants;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PostBlockStateProvider
extends BlockStateProvider {
    public PostBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)ModBlocks.getInstance().getPost());
        for (Direction facingValue : AbstractPostBlock.FACING.getPossibleValues()) {
            for (Boolean upright : AbstractPostBlock.UPRIGHT.getPossibleValues()) {
                for (PostType typeValue : PostBlock.TYPE.getPossibleValues()) {
                    ConfiguredModel.Builder partBuilder = builder.part();
                    ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/post/post_" + typeValue.getSerializedName(), this.modLoc("block/post/post_%s_spec".formatted(typeValue.getSerializedName())))).customLoader(MateriallyTexturedModelBuilder::new)).end()).rotationY(this.getYFromFacing(facingValue)).rotationX(this.getXFromFacing(facingValue) + this.getUpright(upright, facingValue)).addModel()).condition((Property)AbstractPostBlock.UPRIGHT, (Comparable[])new Boolean[]{upright}).condition((Property)AbstractPostBlock.FACING, (Comparable[])new Direction[]{facingValue}).condition((Property)PostBlock.TYPE, (Comparable[])new PostType[]{typeValue}).end();
                }
            }
        }
        ItemModelBuilder itemSpecModelBuilder = (ItemModelBuilder)this.itemModels().withExistingParent("post_spec", this.mcLoc("block/thin_block"));
        PostType[] values = PostType.values();
        for (int i = 0; i < values.length; ++i) {
            PostType value = values[i];
            ItemModelBuilder.OverrideBuilder overrideBuilder = itemSpecModelBuilder.override();
            overrideBuilder.predicate(Constants.POST_MODEL_OVERRIDE, (float)i);
            overrideBuilder.model((ModelFile)this.itemModels().getExistingFile(this.modLoc("block/post/post_%s_spec".formatted(value.getSerializedName()))));
            overrideBuilder.end();
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getPost().getRegistryName().getPath())).parent((ModelFile)itemSpecModelBuilder)).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @Contract(pure=true)
    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getXFromFacing(Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> 180;
            case Direction.DOWN -> 0;
            case Direction.NORTH -> 0;
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 0;
            case Direction.EAST -> 0;
        };
    }

    private int getUpright(Boolean upright, Direction direction) {
        if (!upright.booleanValue() && direction != Direction.DOWN && direction != Direction.UP) {
            return 90;
        }
        return 0;
    }

    @NotNull
    public String getName() {
        return "Post BlockStates Provider";
    }
}

