/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.ILightningStruckBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.mysticaloaktree.block.PlayersRelationshipComponent;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakBlock;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakTile;
import net.mehvahdjukaar.mysticaloaktree.client.TreeLoreManager;
import net.mehvahdjukaar.mysticaloaktree.worldgen.BiomeMatchPredicate;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakDecorator;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakFeature;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakFoliagePlacer;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakTrunkPlacer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.PushReaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysticalOakTree {
    public static final String MOD_ID = "mysticaloaktree";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Supplier<SimpleParticleType> WIND = RegHelper.registerParticle((ResourceLocation)MysticalOakTree.res("wind"));
    public static final Supplier<Block> BLOCK = RegHelper.registerBlockWithItem((ResourceLocation)MysticalOakTree.res("wise_oak"), () -> new WiseOakBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).pushReaction(PushReaction.BLOCK).strength(4.0f, 4.0f)), (Item.Properties)new Item.Properties().rarity(Rarity.EPIC));
    public static final Supplier<BlockEntityType<WiseOakTile>> TILE = RegHelper.registerBlockEntityType((ResourceLocation)MysticalOakTree.res("wise_oak"), () -> PlatHelper.newBlockEntityType(WiseOakTile::new, (Block[])new Block[]{BLOCK.get()}));
    public static final RegSupplier<BlockPredicateType<BiomeMatchPredicate>> BIOME_MATCH_PREDICATE = RegHelper.register((ResourceLocation)MysticalOakTree.res("biome_match"), () -> () -> BiomeMatchPredicate.CODEC, (ResourceKey)Registries.BLOCK_PREDICATE_TYPE);
    public static final RegSupplier<Feature<WiseOakFeature.Configuration>> WISE_OAK_FEATURE = RegHelper.registerFeature((ResourceLocation)MysticalOakTree.res("wise_oak"), WiseOakFeature::new);
    public static final RegSupplier<TrunkPlacerType<WiseOakTrunkPlacer>> WISE_OAK_TRUNK_PLACER = RegHelper.register((ResourceLocation)MysticalOakTree.res("wise_oak_trunk_placer"), () -> new TrunkPlacerType(WiseOakTrunkPlacer.CODEC), (ResourceKey)Registries.TRUNK_PLACER_TYPE);
    public static final RegSupplier<FoliagePlacerType<WiseOakFoliagePlacer>> WISE_OAK_FOLIAGE_PLACER = RegHelper.register((ResourceLocation)MysticalOakTree.res("wise_oak_foliage_placer"), () -> new FoliagePlacerType(WiseOakFoliagePlacer.CODEC), (ResourceKey)Registries.FOLIAGE_PLACER_TYPE);
    public static final RegSupplier<TreeDecoratorType<WiseOakDecorator>> WISE_OAK_DECORATOR = RegHelper.register((ResourceLocation)MysticalOakTree.res("wise_oak_decorator"), () -> new TreeDecoratorType(WiseOakDecorator.CODEC), (ResourceKey)Registries.TREE_DECORATOR_TYPE);
    public static final Supplier<DataComponentType<PlayersRelationshipComponent>> RELATIONSHIP = RegHelper.registerDataComponent((ResourceLocation)MysticalOakTree.res("relationship"), () -> DataComponentType.builder().persistent(PlayersRelationshipComponent.CODEC).build());

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        TreeLoreManager.init();
        MoonlightEventsHelper.addListener(MysticalOakTree::onLightningStrike, ILightningStruckBlockEvent.class);
        RegHelper.addItemsToTabsRegistration(event -> {
            event.add(CreativeModeTabs.NATURAL_BLOCKS, new ItemLike[]{(ItemLike)BLOCK.get()});
            event.add(CreativeModeTabs.FUNCTIONAL_BLOCKS, new ItemLike[]{(ItemLike)BLOCK.get()});
        });
    }

    private static void onLightningStrike(ILightningStruckBlockEvent event) {
        BlockPos pos = event.getPos().above();
        BlockState state = event.getLevel().getBlockState(pos);
        if (state.getBlock() == Blocks.OAK_SAPLING) {
            ServerLevel level = (ServerLevel)event.getLevel();
            BlockState blockState = level.getFluidState(pos).createLegacyBlock();
            level.setBlock(pos, blockState, 4);
            PlacedFeature feature = (PlacedFeature)((Registry)event.getLevel().registryAccess().registry(Registries.PLACED_FEATURE).get()).get(MysticalOakTree.res("wise_oak"));
            if (feature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), level.random, pos)) {
                if (level.getBlockState(pos) == blockState) {
                    level.sendBlockUpdated(pos, state, blockState, 2);
                }
            } else {
                level.setBlock(pos, state, 4);
            }
        }
    }
}

