/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.block;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.block.PlayersRelationshipComponent;
import net.mehvahdjukaar.mysticaloaktree.block.Relationship;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakBlock;
import net.mehvahdjukaar.mysticaloaktree.client.TreeLoreManager;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.DialogueInstance;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.ITreeDialogue;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.TreeDialogueTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WiseOakTile
extends BlockEntity {
    public static final int BLOW_DURATION = 34;
    public static final int FOLLOW_TIME = 60;
    public static final int DIALOGUES_TO_SLEEP = 5;
    public static final int BLINK_TIME = 5;
    private static final double BLOW_DIST = 11.0;
    private static final double THICC_CHANCE = 0.03;
    private final Map<UUID, Relationship> playerRelationship = new HashMap<UUID, Relationship>();
    private Player playerTarget;
    private int blowCounter;
    private int followCounter;
    private int dialoguesUntilSlept = 0;
    @Nullable
    private DialogueInstance currentDialogue = null;

    public WiseOakTile(BlockPos blockPos, BlockState blockState) {
        super(MysticalOakTree.TILE.get(), blockPos, blockState);
    }

    @NotNull
    private Relationship getRelationship(Player player) {
        return this.playerRelationship.computeIfAbsent(player.getUUID(), u -> new Relationship(0));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WiseOakTile tile) {
        if (tile.blowCounter > 0) {
            --tile.blowCounter;
        }
        if (((WiseOakBlock.State)((Object)state.getValue(WiseOakBlock.STATE))).isBlowing()) {
            if (tile.blowCounter <= 0) {
                tile.stopBlowing(level, pos, state, tile);
            }
            if (tile.playerTarget != null && WiseOakTile.isInLineOfSight((Direction)state.getValue((Property)WiseOakBlock.FACING), pos, level, (Entity)tile.playerTarget)) {
                if (level.isClientSide) {
                    tile.blowParticles(state, level, pos);
                }
                tile.blowPlayer(state, level, pos);
            }
        }
        if (level.isClientSide) {
            if (tile.currentDialogue != null && !tile.currentDialogue.tick(pos)) {
                tile.currentDialogue = null;
            }
        } else {
            if (tile.followCounter > 0) {
                if (tile.playerTarget != null) {
                    WiseOakTile.rotateTowardPlayer(state, level, pos, tile.playerTarget);
                }
                --tile.followCounter;
                if (tile.followCounter == 0) {
                    tile.playerTarget = null;
                }
            }
            if (tile.blowCounter == 0 && level.getGameTime() % 23L == 0L && level.random.nextInt(21) == 0) {
                tile.randomTick(state, (ServerLevel)level, pos, level.random);
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean isDay;
        WiseOakBlock.State s = (WiseOakBlock.State)((Object)state.getValue(WiseOakBlock.STATE));
        if (s == WiseOakBlock.State.ANGRY && random.nextInt(3) == 0) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.NONE)));
            return;
        }
        boolean bl = isDay = !level.isNight();
        if (s.canSleep() && (isDay || this.isTiredOfYou(state, level))) {
            this.goToSleep((Level)level, pos, state);
            return;
        }
        if (s == WiseOakBlock.State.SLEEPING && !isDay) {
            this.wakeUp((Level)level, pos, state);
            return;
        }
        if (s.canBlink() && random.nextFloat() < 1.0f) {
            level.scheduleTick(pos, state.getBlock(), 5);
            level.setBlock(pos, (BlockState)state.setValue(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.getBlinking(s))), 3);
        }
    }

    private boolean isTiredOfYou(BlockState state, ServerLevel level) {
        int dial = this.dialoguesUntilSlept - 5;
        int perc = Mth.clamp((int)(8 - dial), (int)1, (int)8);
        return state.getValue(WiseOakBlock.STATE) == WiseOakBlock.State.NONE && level.random.nextInt(perc) == 0;
    }

    private void goToSleep(Level level, BlockPos pos, BlockState state) {
        this.playerTarget = null;
        this.followCounter = 0;
        this.blowCounter = 0;
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.SLEEPING)));
    }

    private void wakeUp(Level level, BlockPos pos, BlockState state) {
        this.dialoguesUntilSlept = 0;
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.NONE)));
    }

    public ItemInteractionResult onInteract(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        boolean wokenUp;
        WiseOakBlock.State treeState = (WiseOakBlock.State)((Object)state.getValue(WiseOakBlock.STATE));
        if (treeState.isAngry()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Relationship r = this.getRelationship(player);
        boolean bl = wokenUp = treeState == WiseOakBlock.State.SLEEPING;
        if (wokenUp || r.checkTalkCooldown(level)) {
            ++this.dialoguesUntilSlept;
            if (level.isClientSide) {
                DialogueInstance dialogue = this.getOrCreateDialogue(wokenUp ? TreeDialogueTypes.WOKEN_UP : TreeDialogueTypes.TALKED_TO, level.random, r);
                if (dialogue != null) {
                    dialogue.interact(pos);
                }
            } else {
                if (wokenUp || r.isInConfidence()) {
                    this.setTrackedTarget(player);
                }
                if (wokenUp || r.isFriendlyAt()) {
                    WiseOakTile.rotateTowardPlayer(state, level, pos, player);
                }
            }
            if (wokenUp) {
                this.wakeUp(level, pos, state);
                r.decrease();
                this.spawnAngryParticles(level, pos, state);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    private DialogueInstance getOrCreateDialogue(ITreeDialogue.Type<?> source, RandomSource randomSource, Relationship r) {
        if (this.currentDialogue == null) {
            this.createRandomDialogue(source, randomSource, r);
        }
        return this.currentDialogue;
    }

    private DialogueInstance createRandomDialogue(ITreeDialogue.Type<?> source, RandomSource randomSource, Relationship r) {
        ITreeDialogue dialogue = TreeLoreManager.getRandomDialogue(source, randomSource, r.getTrust());
        if (dialogue != null) {
            this.currentDialogue = dialogue.createInstance();
            return this.currentDialogue;
        }
        return null;
    }

    public void onAttack(BlockState state, Level level, BlockPos pos, Player player) {
        DialogueInstance dialogue;
        Relationship r = this.getRelationship(player);
        this.spawnAngryParticles(level, pos, state);
        this.startBlowingAt(player, state, pos, level);
        if (level.isClientSide && (dialogue = this.createRandomDialogue(TreeDialogueTypes.HURT, level.random, r)) != null) {
            dialogue.tick(pos);
        }
        r.decrease();
    }

    private void spawnAngryParticles(Level level, BlockPos pos, BlockState state) {
        level.blockEvent(pos, state.getBlock(), 1, 0);
    }

    private void blowParticles(BlockState state, Level level, BlockPos pos) {
        if (this.playerTarget != null) {
            Direction dir = (Direction)state.getValue((Property)WiseOakBlock.FACING);
            Vec3 p = Vec3.atCenterOf((Vec3i)pos);
            p = p.add(MthUtils.V3itoV3((Vec3i)dir.getNormal()).scale(0.6));
            Vec3 speed = p.subtract(this.playerTarget.position().add(0.0, (double)(this.playerTarget.getEyeHeight() * 2.0f / 3.0f), 0.0));
            speed = speed.normalize();
            speed = speed.scale((double)-0.4f);
            for (int j = 0; j < 2; ++j) {
                level.addParticle((ParticleOptions)MysticalOakTree.WIND.get(), p.x + (double)((level.random.nextFloat() - level.random.nextFloat()) * 0.05f), p.y - 0.33 + (double)((level.random.nextFloat() - level.random.nextFloat()) * 0.05f), p.z, speed.x, speed.y, speed.z);
            }
        }
    }

    private void blowPlayer(BlockState state, Level level, BlockPos pos) {
        double max;
        double dist;
        if (this.playerTarget != null && (dist = pos.distToCenterSqr((Position)this.playerTarget.position())) < (max = 121.0)) {
            double strength = 1.0 - dist / max;
            Vec3 direction = WiseOakTile.getViewVector(pos, (Entity)this.playerTarget);
            direction = direction.scale((strength *= 1.0 - 0.25 * this.playerTarget.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)) * 0.25);
            Vec3 vec3 = this.playerTarget.getDeltaMovement();
            this.playerTarget.setDeltaMovement(vec3.x + direction.x, vec3.y + (double)(this.playerTarget.onGround() ? 0.0f : 0.0f), vec3.z + direction.z);
        }
    }

    private static Vec3 getViewVector(BlockPos pos, Entity entity) {
        Vec3 p = Vec3.atCenterOf((Vec3i)pos);
        Vec3 speed = entity.position().subtract(p);
        speed = speed.normalize();
        return speed;
    }

    private void stopBlowing(Level level, BlockPos pos, BlockState state, WiseOakTile tile) {
        tile.playerTarget = null;
        tile.followCounter = 0;
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.ANGRY)));
    }

    private void startBlowingAt(Player player, BlockState state, BlockPos pos, Level level) {
        WiseOakTile.rotateTowardPlayer(state, level, pos, player);
        this.blowCounter = 34;
        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue(WiseOakBlock.STATE, (Comparable)((Object)((double)level.random.nextFloat() < 0.03 ? WiseOakBlock.State.THICC : WiseOakBlock.State.BLOWING))));
        this.setTrackedTarget(player);
    }

    private void setTrackedTarget(Player player) {
        this.playerTarget = player;
        this.followCounter = 60;
    }

    public static void rotateTowardPlayer(BlockState state, Level level, BlockPos pos, Player player) {
        Vec3 v = player.position().subtract((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        Direction d = Direction.getNearest((double)v.x, (double)0.0, (double)v.z);
        if (d.getAxis() != Direction.Axis.Y && state.getValue((Property)HorizontalDirectionalBlock.FACING) != d) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)d));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        PlayersRelationshipComponent component = new PlayersRelationshipComponent(this.playerRelationship);
        tag.put("relationship", (Tag)PlayersRelationshipComponent.CODEC.encodeStart((DynamicOps)ops, (Object)component).getOrThrow());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.playerRelationship.clear();
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        PlayersRelationshipComponent component = (PlayersRelationshipComponent)PlayersRelationshipComponent.CODEC.parse((DynamicOps)ops, (Object)tag.get("relationship")).getOrThrow();
        this.playerRelationship.putAll(component.map());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(MysticalOakTree.RELATIONSHIP.get(), (Object)new PlayersRelationshipComponent(this.playerRelationship));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        PlayersRelationshipComponent component = (PlayersRelationshipComponent)componentInput.get(MysticalOakTree.RELATIONSHIP.get());
        if (component != null) {
            this.playerRelationship.clear();
            this.playerRelationship.putAll(component.map());
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("relationship");
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return super.getUpdateTag(registries);
    }

    private static boolean isInLineOfSight(Direction dir, BlockPos pos, Level level, Entity target) {
        Vec3 startPos = Vec3.atCenterOf((Vec3i)pos).relative(dir, 0.6);
        if (target.distanceToSqr(startPos) > 121.0) {
            return false;
        }
        return WiseOakTile.clip(level, startPos, target.getEyePosition()).getType() == HitResult.Type.MISS;
    }

    public static BlockHitResult clip(Level level, Vec3 startPos, Vec3 endPos) {
        ClipContext.Block blockGetter = ClipContext.Block.COLLIDER;
        ClipContext.Fluid fluidGetter = ClipContext.Fluid.NONE;
        CollisionContext collision = CollisionContext.empty();
        return (BlockHitResult)BlockGetter.traverseBlocks((Vec3)startPos, (Vec3)endPos, null, (Null, pos) -> {
            BlockState blockstate = level.getBlockState(pos);
            FluidState fluidstate = level.getFluidState(pos);
            VoxelShape voxelShape = blockGetter.get(blockstate, (BlockGetter)level, pos, collision);
            BlockHitResult blockHitResult = level.clipWithInteractionOverride(startPos, endPos, pos, voxelShape, blockstate);
            VoxelShape fluidShape = fluidGetter.canPick(fluidstate) ? fluidstate.getShape((BlockGetter)level, pos) : Shapes.empty();
            BlockHitResult fluidHirResult = fluidShape.clip(startPos, endPos, pos);
            double d0 = blockHitResult == null ? Double.MAX_VALUE : startPos.distanceToSqr(blockHitResult.getLocation());
            double d1 = fluidHirResult == null ? Double.MAX_VALUE : startPos.distanceToSqr(fluidHirResult.getLocation());
            return d0 <= d1 ? blockHitResult : fluidHirResult;
        }, arg -> {
            Vec3 vec3 = startPos.subtract(endPos);
            return BlockHitResult.miss((Vec3)endPos, (Direction)Direction.getNearest((double)vec3.x, (double)vec3.y, (double)vec3.z), (BlockPos)BlockPos.containing((Position)endPos));
        });
    }
}

