/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.worldgen;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class WiseOakTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<WiseOakTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> WiseOakTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, WiseOakTrunkPlacer::new));
    private static final List<BlockPos> BRANCH_POS = BlockPos.betweenClosedStream((int)-1, (int)0, (int)-1, (int)1, (int)0, (int)1).filter(blockPos -> blockPos.getZ() != 0 || blockPos.getX() != 0).map(BlockPos::immutable).toList();

    public WiseOakTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)MysticalOakTree.WISE_OAK_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        BlockPos blockPos = pos.below();
        if (config.forceDirt) {
            WiseOakTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)config);
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int py = y + freeTreeHeight - 1;
        for (int h = 0; h < freeTreeHeight; ++h) {
            int r = y + h;
            BlockPos blockPos2 = new BlockPos(x, r, z);
            if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)blockPos2)) continue;
            this.placeLog(level, blockSetter, random, blockPos2, config);
        }
        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x, py, z), 0, false));
        int branches = 1 + random.nextInt(0, 3) + random.nextInt(2);
        ArrayList<BlockPos> dirs = new ArrayList<BlockPos>(BRANCH_POS);
        ArrayList<BlockPos> selected = new ArrayList<BlockPos>();
        for (int j = 0; j < branches && !dirs.isEmpty(); ++j) {
            int i = random.nextInt(dirs.size());
            BlockPos pp = (BlockPos)dirs.remove(i);
            dirs.removeIf(b -> b.distManhattan((Vec3i)pp) == 1);
            selected.add(pp);
        }
        for (BlockPos v : selected) {
            Direction.Axis axis = v.getX() != 0 ? Direction.Axis.X : Direction.Axis.Z;
            int branchH = -2 - random.nextInt(3);
            this.placeLog(level, blockSetter, random, new BlockPos(x + v.getX(), py + branchH, z + v.getZ()), config, blockState -> (BlockState)blockState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis));
            foliageAttachments.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x + v.getX(), py - 1, z + v.getZ()), 0, false));
        }
        return foliageAttachments;
    }
}

