/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import tallestegg.guardvillagers.common.entities.Guard;
import tallestegg.guardvillagers.common.entities.GuardContainer;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.networking.GuardFollowPacket;
import tallestegg.guardvillagers.networking.GuardSetPatrolPosPacket;

public class GuardInventoryScreen
extends AbstractContainerScreen<GuardContainer> {
    private static final ResourceLocation GUARD_GUI_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"textures/container/inventory.png");
    private static final WidgetSprites GUARD_FOLLOWING_ICONS = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"following/following"), ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"following/following_highlighted"));
    private static final WidgetSprites GUARD_NOT_FOLLOWING_ICONS = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"following/not_following"), ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"following/not_following_highlighted"));
    private static final WidgetSprites GUARD_PATROLLING_ICONS = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"patrolling/patrolling1"), ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"patrolling/patrolling2"));
    private static final WidgetSprites GUARD_NOT_PATROLLING_ICONS = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"patrolling/notpatrolling1"), ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"patrolling/notpatrolling2"));
    private static final ResourceLocation ARMOR_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_empty");
    private static final ResourceLocation ARMOR_HALF_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_half");
    private static final ResourceLocation ARMOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
    private final Guard guard;
    private Player player;
    private float mousePosX;
    private float mousePosY;
    private boolean buttonPressed;

    public GuardInventoryScreen(GuardContainer container, Inventory playerInventory, Guard guard) {
        super((AbstractContainerMenu)container, playerInventory, guard.getDisplayName());
        this.guard = guard;
        this.titleLabelX = 80;
        this.inventoryLabelX = 100;
        this.player = playerInventory.player;
    }

    public void init() {
        super.init();
        if (((Boolean)GuardConfig.COMMON.followHero.get()).booleanValue() && this.player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) || !((Boolean)GuardConfig.COMMON.followHero.get()).booleanValue()) {
            this.addRenderableWidget((GuiEventListener)new GuardGuiButton(this.leftPos + 100, this.height / 2 - 40, 20, 18, GUARD_FOLLOWING_ICONS, GUARD_NOT_FOLLOWING_ICONS, true, p_214086_1_ -> PacketDistributor.sendToServer((CustomPacketPayload)new GuardFollowPacket(this.guard.getId()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
        if (((Boolean)GuardConfig.COMMON.setGuardPatrolHotv.get()).booleanValue() && this.player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) || !((Boolean)GuardConfig.COMMON.setGuardPatrolHotv.get()).booleanValue()) {
            this.addRenderableWidget((GuiEventListener)new GuardGuiButton(this.leftPos + 120, this.height / 2 - 40, 20, 18, GUARD_PATROLLING_ICONS, GUARD_NOT_PATROLLING_ICONS, false, p_214086_1_ -> {
                this.buttonPressed = !this.buttonPressed;
                PacketDistributor.sendToServer((CustomPacketPayload)new GuardSetPatrolPosPacket(this.guard.getId(), this.buttonPressed), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }));
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUARD_GUI_TEXTURES);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(GUARD_GUI_TEXTURES, i, j, 0, 0, this.imageWidth, this.imageHeight);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(i + 26), (int)(j + 8), (int)(i + 75), (int)(j + 78), (int)30, (float)0.0625f, (float)this.mousePosX, (float)this.mousePosY, (LivingEntity)this.guard);
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        int yValueWithOrWithoutArmor;
        super.renderLabels(graphics, x, y);
        int health = Mth.ceil((float)this.guard.getHealth());
        int armor = this.guard.getArmorValue();
        MutableComponent guardHealthText = Component.translatable((String)"guardinventory.health", (Object[])new Object[]{health});
        MutableComponent guardArmorText = Component.translatable((String)"guardinventory.armor", (Object[])new Object[]{armor});
        int n = yValueWithOrWithoutArmor = armor <= 0 ? 20 : 30;
        if (!((Boolean)GuardConfig.CLIENT.guardInventoryNumbers.get()).booleanValue() || this.guard.getMaxHealth() > 20.0f) {
            graphics.drawString(this.font, (Component)guardHealthText, 80, 30, 0x404040, false);
        } else if (this.guard.getMaxHealth() <= 20.0f) {
            int heartXValue;
            int i = 0;
            while ((double)i < (double)this.guard.getMaxHealth() * 0.5) {
                heartXValue = i * 8 + 80;
                this.renderHeart(graphics, Gui.HeartType.CONTAINER, heartXValue, yValueWithOrWithoutArmor, false);
                ++i;
            }
            for (i = 0; i < health / 2; ++i) {
                heartXValue = i * 8 + 80;
                if (health % 2 != 0 && health / 2 == i + 1) {
                    this.renderHeart(graphics, Gui.HeartType.NORMAL, heartXValue, yValueWithOrWithoutArmor, true);
                    continue;
                }
                this.renderHeart(graphics, Gui.HeartType.NORMAL, heartXValue, yValueWithOrWithoutArmor, false);
            }
        }
        if (!((Boolean)GuardConfig.CLIENT.guardInventoryNumbers.get()).booleanValue()) {
            graphics.drawString(this.font, (Component)guardArmorText, 80, 20, 0x404040, false);
        } else if (armor > 0) {
            RenderSystem.enableBlend();
            for (int k = 0; k < 10; ++k) {
                int l = k * 8 + 80;
                if (k * 2 + 1 < armor) {
                    graphics.blitSprite(ARMOR_FULL_SPRITE, l, 20, 9, 9);
                }
                if (k * 2 + 1 == armor) {
                    graphics.blitSprite(ARMOR_HALF_SPRITE, l, 20, 9, 9);
                }
                if (k * 2 + 1 <= armor) continue;
                graphics.blitSprite(ARMOR_EMPTY_SPRITE, l, 20, 9, 9);
            }
            RenderSystem.disableBlend();
        }
    }

    private void renderHeart(GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean halfHeart) {
        RenderSystem.enableBlend();
        guiGraphics.blitSprite(heartType.getSprite(false, halfHeart, false), x, y, 9, 9);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseX, partialTicks);
        this.mousePosX = mouseX;
        this.mousePosY = mouseY;
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    class GuardGuiButton
    extends ImageButton {
        private WidgetSprites texture;
        private WidgetSprites newTexture;
        private boolean isFollowButton;

        public GuardGuiButton(int xIn, int yIn, int widthIn, int heightIn, WidgetSprites resourceLocationIn, WidgetSprites newTexture, boolean isFollowButton, Button.OnPress onPressIn) {
            super(xIn, yIn, widthIn, heightIn, resourceLocationIn, onPressIn);
            this.texture = resourceLocationIn;
            this.newTexture = newTexture;
            this.isFollowButton = isFollowButton;
        }

        public boolean requirementsForTexture() {
            boolean following = GuardInventoryScreen.this.guard.isFollowing();
            boolean patrol = GuardInventoryScreen.this.guard.isPatrolling();
            return this.isFollowButton ? following : patrol;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            WidgetSprites icon = this.requirementsForTexture() ? this.texture : this.newTexture;
            ResourceLocation resourcelocation = icon.get(this.isActive(), this.isHoveredOrFocused());
            graphics.blitSprite(resourcelocation, this.getX(), this.getY(), this.width, this.height);
        }
    }
}

