/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.networking;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.common.entities.Guard;

public record GuardFollowPacket(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GuardFollowPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"following"));
    public static final StreamCodec<FriendlyByteBuf, GuardFollowPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, GuardFollowPacket::entityId, GuardFollowPacket::new);

    public static void handle(GuardFollowPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (player != null && player.level() instanceof ServerLevel && (entity = player.level().getEntity(packet.entityId())) instanceof Guard) {
                Guard guard;
                guard.setFollowing(!(guard = (Guard)entity).isFollowing());
                guard.setOwnerId(player.getUUID());
                guard.playSound((SoundEvent)GuardSounds.GUARD_YES.value(), 1.0f, 1.0f);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

