/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.jadecolonies.minecolonies;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

class BuildingPackComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jadecolonies", (String)"colony.pack");
    private static final String PACK_NAME = UID.toString();
    private static final BuildingPackComponentProvider INSTANCE = new BuildingPackComponentProvider();

    BuildingPackComponentProvider() {
    }

    public static BuildingPackComponentProvider getInstance() {
        return INSTANCE;
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    public int getDefaultPriority() {
        return -2999;
    }

    public void appendServerData(@NotNull CompoundTag compoundTag, @NotNull BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding entity = (AbstractTileEntityColonyBuilding)blockEntity;
            IBuilding building = entity.getBuilding();
            if (building == null || building instanceof IRSComponent) {
                return;
            }
            compoundTag.putString(PACK_NAME, building.getStructurePack());
        } else {
            blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof TileEntityDecorationController) {
                TileEntityDecorationController deco = (TileEntityDecorationController)blockEntity;
                compoundTag.putString(PACK_NAME, deco.getPackName());
            }
        }
    }

    public void appendTooltip(@NotNull ITooltip tooltip, @NotNull BlockAccessor blockAccessor, @NotNull IPluginConfig pluginConfig) {
        String name = blockAccessor.getServerData().getString(PACK_NAME);
        if (!name.isEmpty()) {
            tooltip.add((Component)Component.literal((String)name).withStyle(ChatFormatting.DARK_GREEN));
        }
    }
}

