/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.block.LatticeBlock;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.GrapeType;

public class LatticeRenderer
implements BlockEntityRenderer<LatticeBlockEntity> {
    private static Map<Block, ResourceLocation> textureMap;
    private final ModelPart growing_red;
    private final ModelPart sprout;
    private final ModelPart growing_white;
    private final ModelPart mesh;
    private final ModelPart support_right;
    private final ModelPart corner_braces_right;
    private final ModelPart support_left;
    private final ModelPart corner_braces_left;
    private final ModelPart growing_red_floor;
    private final ModelPart sprout_floor;
    private final ModelPart growing_white_floor;
    private final ModelPart lattice_parts;
    private final ModelPart hanging_1_r1;
    private final ModelPart hanging_2_r1;
    public static final ModelLayerLocation LAYER_LOCATION;

    private static Map<Block, ResourceLocation> getTextureMap() {
        if (textureMap == null) {
            textureMap = new HashMap<Block, ResourceLocation>();
            textureMap.put((Block)ObjectRegistry.OAK_LATTICE.get(), Vinery.identifier("textures/block/lattice/oak_lattice.png"));
            textureMap.put((Block)ObjectRegistry.SPRUCE_LATTICE.get(), Vinery.identifier("textures/block/lattice/spruce_lattice.png"));
            textureMap.put((Block)ObjectRegistry.CHERRY_LATTICE.get(), Vinery.identifier("textures/block/lattice/cherry_lattice.png"));
            textureMap.put((Block)ObjectRegistry.BIRCH_LATTICE.get(), Vinery.identifier("textures/block/lattice/birch_lattice.png"));
            textureMap.put((Block)ObjectRegistry.DARK_OAK_LATTICE.get(), Vinery.identifier("textures/block/lattice/dark_oak_lattice.png"));
            textureMap.put((Block)ObjectRegistry.ACACIA_LATTICE.get(), Vinery.identifier("textures/block/lattice/acacia_lattice.png"));
            textureMap.put((Block)ObjectRegistry.BAMBOO_LATTICE.get(), Vinery.identifier("textures/block/lattice/bamboo_lattice.png"));
            textureMap.put((Block)ObjectRegistry.JUNGLE_LATTICE.get(), Vinery.identifier("textures/block/lattice/jungle_lattice.png"));
            textureMap.put((Block)ObjectRegistry.MANGROVE_LATTICE.get(), Vinery.identifier("textures/block/lattice/mangrove_lattice.png"));
            textureMap.put((Block)ObjectRegistry.DARK_CHERRY_LATTICE.get(), Vinery.identifier("textures/block/lattice/dark_cherry_lattice.png"));
        }
        return textureMap;
    }

    public LatticeRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        ModelPart lattice_wall = root.getChild("lattice_wall");
        ModelPart grape_cluster = lattice_wall.getChild("grape_cluster");
        this.growing_red = grape_cluster.getChild("growing_red");
        this.sprout = grape_cluster.getChild("sprout");
        this.growing_white = grape_cluster.getChild("growing_white");
        this.mesh = lattice_wall.getChild("mesh");
        this.support_right = lattice_wall.getChild("support_right");
        this.corner_braces_right = lattice_wall.getChild("corner_braces_right");
        this.support_left = lattice_wall.getChild("support_left");
        this.corner_braces_left = lattice_wall.getChild("corner_braces_left");
        ModelPart lattice_floor = root.getChild("lattice_floor");
        ModelPart grape_cluster_floor = lattice_floor.getChild("grape_cluster_floor");
        this.growing_red_floor = grape_cluster_floor.getChild("growing_red_floor");
        this.sprout_floor = grape_cluster_floor.getChild("sprout_floor");
        this.growing_white_floor = grape_cluster_floor.getChild("growing_white_floor");
        this.lattice_parts = lattice_floor.getChild("lattice_parts");
        this.hanging_1_r1 = grape_cluster_floor.getChild("hanging_1_r1");
        this.hanging_2_r1 = grape_cluster_floor.getChild("hanging_2_r1");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition lattice_wall = partdefinition.addOrReplaceChild("lattice_wall", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition grape_cluster = lattice_wall.addOrReplaceChild("grape_cluster", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-10.0f));
        PartDefinition growing_red = grape_cluster.addOrReplaceChild("growing_red", CubeListBuilder.create().texOffs(46, 17).addBox(-15.0f, -16.0f, -10.5f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)0.0f, (float)17.0f));
        PartDefinition sprout = grape_cluster.addOrReplaceChild("sprout", CubeListBuilder.create().texOffs(46, 0).addBox(-15.0f, -16.0f, -10.5f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)0.0f, (float)17.0f));
        PartDefinition growing_white = grape_cluster.addOrReplaceChild("growing_white", CubeListBuilder.create().texOffs(46, 34).addBox(-15.0f, -16.0f, -10.5f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)0.0f, (float)17.0f));
        PartDefinition mesh = lattice_wall.addOrReplaceChild("mesh", CubeListBuilder.create().texOffs(48, 64).addBox(-30.0f, -12.0f, 2.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)22.0f, (float)-4.0f, (float)5.0f));
        PartDefinition support_right = lattice_wall.addOrReplaceChild("support_right", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -9.0f, 7.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)14.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition corner_braces_right = lattice_wall.addOrReplaceChild("corner_braces_right", CubeListBuilder.create().texOffs(8, 0).addBox(6.0f, -16.0f, -2.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_right_bottom_r1 = corner_braces_right.addOrReplaceChild("corner_braces_right_bottom_r1", CubeListBuilder.create().texOffs(8, 10).addBox(-7.99f, -4.0f, 6.0f, 1.98f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)14.0f, (float)-7.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_right_top_r1 = corner_braces_right.addOrReplaceChild("corner_braces_right_top_r1", CubeListBuilder.create().texOffs(3, 10).addBox(-7.99f, -6.0f, -5.5f, 1.98f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)14.0f, (float)-7.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition support_left = lattice_wall.addOrReplaceChild("support_left", CubeListBuilder.create().texOffs(0, 0).addBox(-16.0f, -16.0f, 14.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)0.0f, (float)-8.0f));
        PartDefinition corner_braces_left = lattice_wall.addOrReplaceChild("corner_braces_left", CubeListBuilder.create().texOffs(8, 0).addBox(-8.0f, -16.0f, -2.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_left_top_r1 = corner_braces_left.addOrReplaceChild("corner_braces_left_top_r1", CubeListBuilder.create().texOffs(8, 10).addBox(-7.99f, -4.0f, 6.0f, 1.98f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_left_bottom_r1 = corner_braces_left.addOrReplaceChild("corner_braces_left_bottom_r1", CubeListBuilder.create().texOffs(3, 10).addBox(-7.99f, -6.0f, -5.5f, 1.98f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition lattice_floor = partdefinition.addOrReplaceChild("lattice_floor", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition grape_cluster_floor = lattice_floor.addOrReplaceChild("grape_cluster_floor", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.5f, (float)4.0f));
        PartDefinition hanging_2_r1 = grape_cluster_floor.addOrReplaceChild("hanging_2_r1", CubeListBuilder.create().texOffs(32, 14).addBox(-7.0f, -11.5f, -1.0f, 8.0f, 12.0f, 0.0f), PartPose.offsetAndRotation((float)2.8284f, (float)14.5f, (float)-3.4142f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition hanging_1_r1 = grape_cluster_floor.addOrReplaceChild("hanging_1_r1", CubeListBuilder.create().texOffs(32, 0).addBox(-7.0f, -9.5f, -1.0f, 8.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)1.4142f, (float)12.5f, (float)0.8284f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition growing_red_floor = grape_cluster_floor.addOrReplaceChild("growing_red_floor", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.5f, (float)1.0f));
        PartDefinition growing_red_floor_r1 = growing_red_floor.addOrReplaceChild("growing_red_floor_r1", CubeListBuilder.create().texOffs(2, 52).addBox(-18.0f, -30.5f, -3.0f, 16.0f, 1.0f, 12.0f), PartPose.offsetAndRotation((float)3.0f, (float)32.5f, (float)8.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition sprout_floor = grape_cluster_floor.addOrReplaceChild("sprout_floor", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.5f, (float)1.0f));
        PartDefinition sprouting_grapes_floor_r1 = sprout_floor.addOrReplaceChild("sprouting_grapes_floor_r1", CubeListBuilder.create().texOffs(2, 39).addBox(-18.0f, -30.5f, -3.0f, 16.0f, 1.0f, 12.0f), PartPose.offsetAndRotation((float)3.0f, (float)32.5f, (float)8.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition growing_white_floor = grape_cluster_floor.addOrReplaceChild("growing_white_floor", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.5f, (float)1.0f));
        PartDefinition growing_white_floor_r1 = growing_white_floor.addOrReplaceChild("growing_white_floor_r1", CubeListBuilder.create().texOffs(2, 65).addBox(-18.0f, -30.5f, -3.0f, 16.0f, 1.0f, 12.0f), PartPose.offsetAndRotation((float)3.0f, (float)32.5f, (float)8.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition lattice_parts = lattice_floor.addOrReplaceChild("lattice_parts", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cross_brace_r1 = lattice_parts.addOrReplaceChild("cross_brace_r1", CubeListBuilder.create().texOffs(-12, 24).addBox(-18.0f, -29.0f, -3.0f, 16.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)28.0f, (float)10.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition support_floor_left_r1 = lattice_parts.addOrReplaceChild("support_floor_left_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-16.0f, -16.0f, 14.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).mirror().addBox(-30.0f, -16.0f, 14.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)22.0f, (float)-16.0f, (float)-8.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)80, (int)80);
    }

    public void render(LatticeBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        BlockState state = blockEntity.getBlockState();
        Direction direction = (Direction)state.getValue((Property)LatticeBlock.FACING);
        boolean support = (Boolean)state.getValue((Property)LatticeBlock.SUPPORT);
        boolean bottom = (Boolean)state.getValue((Property)LatticeBlock.BOTTOM);
        GeneralUtil.LineConnectingType type = (GeneralUtil.LineConnectingType)((Object)state.getValue(LatticeBlock.TYPE));
        int age = (Integer)state.getValue((Property)LatticeBlock.AGE);
        GrapeType grapeType = (GrapeType)state.getValue((Property)LatticeBlock.GRAPE);
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Block block = state.getBlock();
        ResourceLocation texture = LatticeRenderer.getTextureMap().getOrDefault(block, Vinery.identifier("textures/entity/lattice/default_lattice.png"));
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture));
        if (bottom) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.scale(1.0f, -1.0f, -1.0f);
            this.lattice_parts.render(poseStack, consumer, packedLight, packedOverlay);
            if (!grapeType.equals(GrapeTypeRegistry.NONE)) {
                if (age < 4) {
                    this.sprout_floor.render(poseStack, consumer, packedLight, packedOverlay);
                } else if (grapeType.isRed()) {
                    this.growing_red_floor.render(poseStack, consumer, packedLight, packedOverlay);
                } else {
                    this.growing_white_floor.render(poseStack, consumer, packedLight, packedOverlay);
                }
            }
        } else {
            this.mesh.render(poseStack, consumer, packedLight, packedOverlay);
            if (type != GeneralUtil.LineConnectingType.MIDDLE && type != GeneralUtil.LineConnectingType.LEFT) {
                this.support_right.render(poseStack, consumer, packedLight, packedOverlay);
                if (support) {
                    this.corner_braces_right.render(poseStack, consumer, packedLight, packedOverlay);
                }
            }
            if (type != GeneralUtil.LineConnectingType.MIDDLE && type != GeneralUtil.LineConnectingType.RIGHT) {
                this.support_left.render(poseStack, consumer, packedLight, packedOverlay);
                if (support) {
                    this.corner_braces_left.render(poseStack, consumer, packedLight, packedOverlay);
                }
            }
        }
        if (!grapeType.equals(GrapeTypeRegistry.NONE)) {
            boolean isRed = grapeType.isRed();
            if (bottom) {
                if (age < 4) {
                    this.sprout_floor.render(poseStack, consumer, packedLight, packedOverlay);
                } else if (isRed) {
                    this.growing_red_floor.render(poseStack, consumer, packedLight, packedOverlay);
                } else {
                    this.growing_white_floor.render(poseStack, consumer, packedLight, packedOverlay);
                }
            } else if (age < 4) {
                this.sprout.render(poseStack, consumer, packedLight, packedOverlay);
            } else if (isRed) {
                this.growing_red.render(poseStack, consumer, packedLight, packedOverlay);
            } else {
                this.growing_white.render(poseStack, consumer, packedLight, packedOverlay);
            }
        }
        if (bottom && blockEntity.shouldShowHanging()) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            poseStack.scale(1.0f, -1.0f, -1.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            RandomSource random = RandomSource.create((long)blockEntity.getBlockPos().asLong());
            float offsetX = Mth.lerp((float)random.nextFloat(), (float)-0.02f, (float)0.0f);
            float offsetZ = Mth.lerp((float)random.nextFloat(), (float)-0.02f, (float)0.0f);
            poseStack.translate(offsetX, -0.2f, offsetZ);
            this.hanging_1_r1.render(poseStack, consumer, packedLight, packedOverlay);
            this.hanging_2_r1.render(poseStack, consumer, packedLight, packedOverlay);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    static {
        LAYER_LOCATION = new ModelLayerLocation(Vinery.identifier("lattice"), "main");
    }
}

