/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.render.block.storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.vinery.client.render.block.storage.StorageTypeRenderer;
import net.satisfy.vinery.client.util.ClientUtil;
import net.satisfy.vinery.core.block.WineBottleBlock;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;
import net.satisfy.vinery.core.item.DrinkBlockItem;
import net.satisfy.vinery.core.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public class WineBottleRenderer
implements StorageTypeRenderer {
    @Override
    public void render(StorageBlockEntity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, NonNullList<ItemStack> nonNullList) {
        poseStack.translate(-0.5, 0.0, -0.5);
        switch (this.getCount(nonNullList)) {
            case 1: {
                this.renderOne(entity, poseStack, multiBufferSource, nonNullList);
                break;
            }
            case 2: {
                this.renderTwo(entity, poseStack, multiBufferSource, nonNullList);
                break;
            }
            case 3: {
                this.renderThree(entity, poseStack, multiBufferSource, nonNullList);
            }
        }
    }

    public int getCount(NonNullList<ItemStack> nonNullList) {
        int count = 0;
        for (ItemStack stack : nonNullList) {
            if (stack.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private void renderOne(StorageBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, NonNullList<ItemStack> nonNullList) {
        Item item = ((ItemStack)nonNullList.get(0)).getItem();
        if (item instanceof DrinkBlockItem) {
            DrinkBlockItem item2 = (DrinkBlockItem)item;
            ClientUtil.renderBlock(WineBottleRenderer.getState(item2), matrices, vertexConsumers, entity);
        }
    }

    private static BlockState getState(DrinkBlockItem item) {
        BlockState state = item.getBlock().defaultBlockState();
        if (state.hasProperty((Property)WineBottleBlock.FAKE_MODEL)) {
            state = (BlockState)state.setValue((Property)WineBottleBlock.FAKE_MODEL, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private void renderTwo(StorageBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, NonNullList<ItemStack> nonNullList) {
        DrinkBlockItem item;
        DrinkBlockItem item2;
        Item item3 = ((ItemStack)nonNullList.get(0)).getItem();
        DrinkBlockItem item1 = item3 instanceof DrinkBlockItem ? (item2 = (DrinkBlockItem)item3) : null;
        Item item4 = ((ItemStack)nonNullList.get(1)).getItem();
        DrinkBlockItem item22 = item4 instanceof DrinkBlockItem ? (item = (DrinkBlockItem)item4) : null;
        matrices.translate(-0.15f, 0.0f, -0.25f);
        if (item1 != null) {
            ClientUtil.renderBlock(WineBottleRenderer.getState(item1), matrices, vertexConsumers, entity);
        }
        matrices.translate(0.1f, 0.0f, 0.8f);
        matrices.mulPose(Axis.YP.rotationDegrees(30.0f));
        if (item22 != null) {
            ClientUtil.renderBlock(WineBottleRenderer.getState(item22), matrices, vertexConsumers, entity);
        }
    }

    private void renderThree(StorageBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, NonNullList<ItemStack> nonNullList) {
        DrinkBlockItem item;
        DrinkBlockItem item2;
        DrinkBlockItem item3;
        Item item4 = ((ItemStack)nonNullList.get(0)).getItem();
        DrinkBlockItem item1 = item4 instanceof DrinkBlockItem ? (item3 = (DrinkBlockItem)item4) : null;
        Item item5 = ((ItemStack)nonNullList.get(1)).getItem();
        DrinkBlockItem item22 = item5 instanceof DrinkBlockItem ? (item2 = (DrinkBlockItem)item5) : null;
        Item item6 = ((ItemStack)nonNullList.get(2)).getItem();
        DrinkBlockItem item32 = item6 instanceof DrinkBlockItem ? (item = (DrinkBlockItem)item6) : null;
        matrices.translate(-0.25f, 0.0f, -0.25f);
        if (item1 != null) {
            ClientUtil.renderBlock(WineBottleRenderer.getState(item1), matrices, vertexConsumers, entity);
        }
        matrices.translate(0.15f, 0.0f, 0.5f);
        if (item22 != null) {
            ClientUtil.renderBlock(WineBottleRenderer.getState(item22), matrices, vertexConsumers, entity);
        }
        if (item32 == null) {
            return;
        }
        if (item32.asItem().equals(((Block)ObjectRegistry.KELP_CIDER.get()).asItem())) {
            matrices.translate(0.35f, 0.7f, -0.13f);
            matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
            ClientUtil.renderBlock(WineBottleRenderer.getState(item32), matrices, vertexConsumers, entity);
            return;
        }
        matrices.translate(0.1f, 0.0f, 0.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(30.0f));
        ClientUtil.renderBlock(WineBottleRenderer.getState(item32), matrices, vertexConsumers, entity);
    }
}

