/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.core.block.entity.DarkCherryBarrelBlockEntity;
import org.jetbrains.annotations.NotNull;

public class DarkCherryBarrelBlock
extends BarrelBlock {
    public DarkCherryBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DarkCherryBarrelBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof DarkCherryBarrelBlockEntity) {
            DarkCherryBarrelBlockEntity provider = (DarkCherryBarrelBlockEntity)be;
            player.openMenu((MenuProvider)provider);
            player.awardStat(Stats.OPEN_BARREL);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        MenuProvider provider;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof MenuProvider ? (provider = (MenuProvider)blockEntity) : null;
    }
}

