/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.satisfy.vinery.core.block.StorageBlock;
import net.satisfy.vinery.core.registry.StorageTypeRegistry;
import net.satisfy.vinery.core.registry.TagRegistry;

public class NineBottleStorageBlock
extends StorageBlock {
    public NineBottleStorageBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public int size() {
        return 9;
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return stack.is(TagRegistry.SMALL_BOTTLE);
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.NINE_BOTTLE;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN, Direction.UP};
    }

    @Override
    public int getSection(Float x, Float y) {
        int nSection;
        float l = 0.33333334f;
        if (x.floatValue() < 0.375f) {
            nSection = 0;
        } else {
            int n = nSection = x.floatValue() < 0.6875f ? 1 : 2;
        }
        int i = y.floatValue() >= l * 2.0f ? 0 : (y.floatValue() >= l ? 1 : 2);
        return nSection + i * 3;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        MutableComponent allBold = Component.translatable((String)"tooltip.vinery.small_bottle_first").withStyle(style -> style.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY));
        MutableComponent allRest = Component.translatable((String)"tooltip.vinery.small_bottle_rest").withStyle(ChatFormatting.GRAY);
        MutableComponent combined = Component.empty().append((Component)allBold).append(" ").append((Component)allRest);
        MutableComponent full = Component.translatable((String)"tooltip.vinery.storage", (Object[])new Object[]{combined}).withStyle(ChatFormatting.GRAY);
        tooltip.add((Component)full);
    }
}

