/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class SpreadableGrassSlabBlock
extends SlabBlock
implements BonemealableBlock {
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;
    public static final Block GRASS_BLOCK = Blocks.GRASS_BLOCK;

    public static Block getDirtSlabBlock() {
        return (Block)ObjectRegistry.DIRT_SLAB.get();
    }

    public static Block getGrassSlabBlock() {
        return (Block)ObjectRegistry.GRASS_SLAB.get();
    }

    public SpreadableGrassSlabBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canSurviveNew(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = world.getBlockState(blockPos);
        if (state.getBlock().equals(SpreadableGrassSlabBlock.getDirtSlabBlock()) && state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM) {
            return (Boolean)state.getValue((Property)SlabBlock.WATERLOGGED) == false;
        }
        if (blockState.is(Blocks.SNOW) && (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockState.getFluidState().getAmount() == 8) {
            return false;
        }
        if (state.is(BlockTags.WALLS) && blockState.is(BlockTags.WALLS) && blockState.canOcclude()) {
            return false;
        }
        if (blockState.getBlock() instanceof SlabBlock && blockState.getValue((Property)SlabBlock.TYPE) == SlabType.TOP) {
            return true;
        }
        if (blockState.getBlock() instanceof StairBlock && blockState.getValue((Property)StairBlock.HALF) == Half.TOP) {
            return true;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)GRASS_BLOCK.defaultBlockState(), (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.getLightBlock((BlockGetter)world, blockPos));
        return i < world.getMaxLightLevel();
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (blockState.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM) {
            return false;
        }
        return levelReader.getBlockState(blockPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        GrassBlock block = (GrassBlock)GRASS_BLOCK;
        block.performBonemeal(world, random, pos, state);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!SpreadableGrassSlabBlock.canSurviveNew(state, (LevelReader)world, pos)) {
            world.setBlock(pos, SpreadableGrassSlabBlock.getDirtSlabBlock().withPropertiesOf(state), 2);
        } else if (world.getMaxLocalRawBrightness(pos.above()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                SpreadableGrassSlabBlock.trySpread(world, blockPos);
            }
        }
    }

    public static void trySpread(ServerLevel world, BlockPos spreadPos) {
        BlockState oldState = world.getBlockState(spreadPos);
        if (oldState.is(Blocks.DIRT) || oldState.is(SpreadableGrassSlabBlock.getDirtSlabBlock())) {
            BlockState aboveState = world.getBlockState(spreadPos.above());
            boolean isSnowy = aboveState.is(Blocks.SNOW);
            BlockState newState = null;
            if (oldState.is(Blocks.DIRT)) {
                newState = (BlockState)GRASS_BLOCK.defaultBlockState().setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(isSnowy));
            } else if (oldState.is(SpreadableGrassSlabBlock.getDirtSlabBlock())) {
                newState = (BlockState)SpreadableGrassSlabBlock.getGrassSlabBlock().withPropertiesOf(oldState).setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(isSnowy));
            }
            if (newState != null && SpreadableGrassSlabBlock.canSurviveNew(newState, (LevelReader)world, spreadPos) && !world.getFluidState(spreadPos.above()).is(FluidTags.WATER)) {
                world.setBlockAndUpdate(spreadPos, newState);
            }
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldItem.is(ItemTags.SHOVELS)) {
            if (!world.isClientSide) {
                BlockState pathState = (BlockState)((BlockState)((Block)ObjectRegistry.DIRT_PATH_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
                world.setBlock(pos, pathState, 3);
                world.playSound(null, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    heldItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SNOWY});
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        state = (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(world.getBlockState(pos.above()).is(BlockTags.SNOW)));
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }
}

