/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class JellieEffect
extends MobEffect {
    public JellieEffect() {
        super(MobEffectCategory.BENEFICIAL, 10017154);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 50 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.getHealth() < entity.getMaxHealth()) {
            entity.heal(1.0f);
        }
        return true;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        entity.setAbsorptionAmount(entity.getAbsorptionAmount() + (float)(4 * (amplifier + 1)));
        super.onEffectStarted(entity, amplifier);
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        entity.setAbsorptionAmount(entity.getAbsorptionAmount() - (float)(4 * (amplifier + 1)));
        super.onEffectAdded(entity, amplifier);
    }
}

