/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.item;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

public class GrapeItem
extends Item {
    private static final double CHANCE_OF_GETTING_SEEDS = 0.2;
    private final Item returnItem;
    private final GrapeType type;

    public GrapeItem(Item.Properties settings, GrapeType type, Item returnItem) {
        super(settings);
        this.type = type;
        this.returnItem = returnItem;
    }

    public GrapeType getType() {
        return this.type;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (!world.isClientSide() && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (stack.getItem() == this && (double)world.getRandom().nextFloat() < 0.2) {
                ItemStack returnStack = new ItemStack((ItemLike)this.returnItem);
                if (!player.getInventory().add(returnStack)) {
                    player.drop(returnStack, false);
                }
            }
        }
        return super.finishUsingItem(stack, world, entityLiving);
    }
}

