/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.block.GrapeBush;
import net.satisfy.vinery.core.util.GrapeType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Fox.FoxEatBerriesGoal.class})
public abstract class FoxEntityEatSweetBerriesGoalMixin
extends MoveToBlockGoal {
    @Final
    @Shadow
    Fox this$0;

    public FoxEntityEatSweetBerriesGoalMixin(PathfinderMob mob, double speed, int range) {
        super(mob, speed, range);
    }

    @Inject(method={"isValidTarget(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isTargetPos(LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof GrapeBush) {
            cir.setReturnValue((Object)((Integer)state.getValue((Property)GrapeBush.AGE) >= 2 ? 1 : 0));
        }
    }

    @Inject(method={"onReachedTarget()V"}, at={@At(value="TAIL")})
    private void eatGrapes(CallbackInfo ci) {
        BlockState state = this.this$0.level().getBlockState(this.blockPos);
        Block block = state.getBlock();
        if (block instanceof GrapeBush) {
            GrapeBush bush = (GrapeBush)block;
            this.pickGrapes(state, bush.grapeType());
        }
    }

    @Unique
    private void pickGrapes(BlockState state, GrapeType type) {
        int age = (Integer)state.getValue((Property)GrapeBush.AGE);
        state.setValue((Property)GrapeBush.AGE, (Comparable)Integer.valueOf(1));
        int j = 1 + this.this$0.level().random.nextInt(2) + (age == 3 ? 1 : 0);
        ItemStack itemStack = this.this$0.getItemBySlot(EquipmentSlot.MAINHAND);
        ItemStack grape = FoxEntityEatSweetBerriesGoalMixin.getGrapeFor(type);
        if (itemStack.isEmpty()) {
            this.this$0.setItemSlot(EquipmentSlot.MAINHAND, grape);
            --j;
        }
        if (j > 0) {
            Block.popResource((Level)this.this$0.level(), (BlockPos)this.blockPos, (ItemStack)new ItemStack((ItemLike)grape.getItem(), j));
        }
        this.this$0.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
        this.this$0.level().setBlock(this.blockPos, (BlockState)state.setValue((Property)GrapeBush.AGE, (Comparable)Integer.valueOf(1)), 2);
    }

    @Unique
    private static ItemStack getGrapeFor(GrapeType type) {
        return type.getFruit().getDefaultInstance();
    }
}

