/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.recipe.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public record FermentationBarrelRecipeInput(List<ItemStack> ingredientStacks, ItemStack wineBottle, JuiceData data) implements RecipeInput
{
    public static final int WINE_BOTTLE_SLOT = 0;

    public ItemStack getItem(int i) {
        if (i == 0) {
            return this.wineBottle;
        }
        return this.ingredientStacks.get(i - 1);
    }

    public int size() {
        return this.ingredientStacks.size() + 1;
    }

    public List<ItemStack> getIngredientSlots() {
        return this.ingredientStacks;
    }

    public record JuiceData(String type, int amount) {
        public static final MapCodec<JuiceData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(JuiceData::type), (App)Codec.INT.fieldOf("amount").forGetter(JuiceData::amount)).apply((Applicative)instance, JuiceData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, JuiceData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, JuiceData>(){

            public JuiceData decode(RegistryFriendlyByteBuf buf) {
                return new JuiceData(buf.readUtf(), buf.readInt());
            }

            public void encode(RegistryFriendlyByteBuf buf, JuiceData data) {
                buf.writeUtf(data.type());
                buf.writeInt(data.amount());
            }
        };
    }
}

