/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.vinery.client.model.StrawHatModel;
import net.satisfy.vinery.client.model.WinemakerBootsModel;
import net.satisfy.vinery.client.model.WinemakerChestplateModel;
import net.satisfy.vinery.client.model.WinemakerLeggingsModel;
import net.satisfy.vinery.core.item.WinemakerBootsItem;
import net.satisfy.vinery.core.item.WinemakerChestItem;
import net.satisfy.vinery.core.item.WinemakerHelmetItem;
import net.satisfy.vinery.core.item.WinemakerLegsItem;
import net.satisfy.vinery.core.registry.ArmorRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ArmorRegistryClient {
    private static final Map<Item, StrawHatModel<?>> models = new HashMap();
    private static final Map<Item, WinemakerChestplateModel<?>> chestplateModels = new HashMap();
    private static final Map<Item, WinemakerLeggingsModel<?>> leggingsModels = new HashMap();
    private static final Map<Item, WinemakerBootsModel<?>> bootsModels = new HashMap();

    public static EntityModel<?> getHatModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.getInstance().getEntityModels();
        StrawHatModel model = models.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.STRAW_HAT.get()) {
                return new StrawHatModel(modelSet.bakeLayer(StrawHatModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead);
        }
        return model;
    }

    public static EntityModel<?> getChestplateModel(Item item, ModelPart body, ModelPart leftArm, ModelPart rightArm, ModelPart leftLeg, ModelPart rightLeg) {
        WinemakerChestplateModel model = chestplateModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.WINEMAKER_APRON.get()) {
                return new WinemakerChestplateModel(Minecraft.getInstance().getEntityModels().bakeLayer(WinemakerChestplateModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyBody(body, leftArm, rightArm, leftLeg, rightLeg);
        }
        return model;
    }

    public static EntityModel<?> getLeggingsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        WinemakerLeggingsModel model = leggingsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.WINEMAKER_LEGGINGS.get()) {
                return new WinemakerLeggingsModel(Minecraft.getInstance().getEntityModels().bakeLayer(WinemakerLeggingsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static EntityModel<?> getBootsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        WinemakerBootsModel model = bootsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.WINEMAKER_BOOTS.get()) {
                return new WinemakerBootsModel(Minecraft.getInstance().getEntityModels().bakeLayer(WinemakerBootsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static void appendToolTip(@NotNull List<Component> tooltip) {
        boolean hasFullSet;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack leggings = player.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
        ArmorRegistry.setBonusActive = hasFullSet = helmet.getItem() instanceof WinemakerHelmetItem && chestplate.getItem() instanceof WinemakerChestItem && leggings.getItem() instanceof WinemakerLegsItem && boots.getItem() instanceof WinemakerBootsItem;
        tooltip.add(Component.nullToEmpty((String)""));
        tooltip.add(Component.nullToEmpty((String)(String.valueOf(ChatFormatting.DARK_GREEN) + I18n.get((String)"tooltip.vinery.armor.winemaker_armor0", (Object[])new Object[0]))));
        tooltip.add(Component.nullToEmpty((String)((helmet.getItem() instanceof WinemakerHelmetItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.STRAW_HAT.get()).getDescription().getString() + "]")));
        tooltip.add(Component.nullToEmpty((String)((chestplate.getItem() instanceof WinemakerChestItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_APRON.get()).getDescription().getString() + "]")));
        tooltip.add(Component.nullToEmpty((String)((leggings.getItem() instanceof WinemakerLegsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_LEGGINGS.get()).getDescription().getString() + "]")));
        tooltip.add(Component.nullToEmpty((String)((boots.getItem() instanceof WinemakerBootsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_BOOTS.get()).getDescription().getString() + "]")));
        tooltip.add(Component.nullToEmpty((String)""));
        ChatFormatting color = hasFullSet ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        tooltip.add(Component.nullToEmpty((String)(String.valueOf(color) + I18n.get((String)"tooltip.vinery.armor.winemaker_armor1", (Object[])new Object[0]))));
        tooltip.add(Component.nullToEmpty((String)(String.valueOf(color) + I18n.get((String)"tooltip.vinery.armor.winemaker_armor2", (Object[])new Object[0]))));
    }
}

