/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.block.entity.ApplePressBlockEntity;
import net.satisfy.vinery.core.block.entity.CabinetBlockEntity;
import net.satisfy.vinery.core.block.entity.CompletionistBannerEntity;
import net.satisfy.vinery.core.block.entity.DarkCherryBarrelBlockEntity;
import net.satisfy.vinery.core.block.entity.DarkCherryHangingSignBlockEntity;
import net.satisfy.vinery.core.block.entity.DarkCherrySignBlockEntity;
import net.satisfy.vinery.core.block.entity.FermentationBarrelBlockEntity;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;
import net.satisfy.vinery.core.block.entity.StoragePotBlockEntity;
import net.satisfy.vinery.core.entity.ChairEntity;
import net.satisfy.vinery.core.entity.DarkCherryBoatEntity;
import net.satisfy.vinery.core.entity.DarkCherryChestBoatEntity;
import net.satisfy.vinery.core.entity.TraderMuleEntity;
import net.satisfy.vinery.core.entity.WanderingWinemakerEntity;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.StorageTypeRegistry;
import net.satisfy.vinery.platform.PlatformHelper;

public class EntityTypeRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<DarkCherrySignBlockEntity>> MOD_SIGN = BLOCK_ENTITY_TYPES.register("mod_sign", () -> BlockEntityType.Builder.of(DarkCherrySignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DARK_CHERRY_SIGN.get(), (Block)ObjectRegistry.DARK_CHERRY_WALL_SIGN.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<DarkCherryHangingSignBlockEntity>> MOD_HANGING_SIGN = BLOCK_ENTITY_TYPES.register("mod_hanging_sign", () -> BlockEntityType.Builder.of(DarkCherryHangingSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DARK_CHERRY_HANGING_SIGN.get(), (Block)ObjectRegistry.DARK_CHERRY_WALL_HANGING_SIGN.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.of(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> {
        Block[] cabinetBlocks = StorageTypeRegistry.getCabinetBlocks();
        return BlockEntityType.Builder.of(CabinetBlockEntity::new, (Block[])cabinetBlocks).build(null);
    });
    public static final RegistrySupplier<BlockEntityType<StoragePotBlockEntity>> STORAGE_POT_ENTITY = EntityTypeRegistry.registerBlockEntity("storage_pot", () -> BlockEntityType.Builder.of(StoragePotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.STORAGE_POT.get()}).build(null));
    public static final Supplier<EntityType<DarkCherryBoatEntity>> DARK_CHERRY_BOAT = PlatformHelper.registerBoatType("dark_cherry_boat", DarkCherryBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final Supplier<EntityType<DarkCherryChestBoatEntity>> DARK_CHERRY_CHEST_BOAT = PlatformHelper.registerBoatType("dark_cherry_chest_boat", DarkCherryChestBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final RegistrySupplier<BlockEntityType<ApplePressBlockEntity>> APPLE_PRESS_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("apple_press", () -> BlockEntityType.Builder.of(ApplePressBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.APPLE_PRESS.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<FermentationBarrelBlockEntity>> FERMENTATION_BARREL_ENTITY = EntityTypeRegistry.registerBlockEntity("fermentation_barrel", () -> BlockEntityType.Builder.of(FermentationBarrelBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FERMENTATION_BARREL.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> VINERY_STANDARD = EntityTypeRegistry.registerBlockEntity("vinery_standard", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.VINERY_STANDARD.get(), (Block)ObjectRegistry.VINERY_WALL_STANDARD.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<DarkCherryBarrelBlockEntity>> DARK_CHERRY_BARREL_ENTITY = EntityTypeRegistry.registerBlockEntity("dark_cherry_barrel", () -> BlockEntityType.Builder.of(DarkCherryBarrelBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DARK_CHERRY_BARREL.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<LatticeBlockEntity>> LATTICE = EntityTypeRegistry.registerBlockEntity("lattice", () -> BlockEntityType.Builder.of(LatticeBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.OAK_LATTICE.get(), (Block)ObjectRegistry.SPRUCE_LATTICE.get(), (Block)ObjectRegistry.CHERRY_LATTICE.get(), (Block)ObjectRegistry.BIRCH_LATTICE.get(), (Block)ObjectRegistry.DARK_OAK_LATTICE.get(), (Block)ObjectRegistry.ACACIA_LATTICE.get(), (Block)ObjectRegistry.BAMBOO_LATTICE.get(), (Block)ObjectRegistry.JUNGLE_LATTICE.get(), (Block)ObjectRegistry.MANGROVE_LATTICE.get(), (Block)ObjectRegistry.DARK_CHERRY_LATTICE.get()}).build(null));
    public static final RegistrySupplier<EntityType<TraderMuleEntity>> MULE = EntityTypeRegistry.registerEntity("mule", () -> EntityType.Builder.of(TraderMuleEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.87f).clientTrackingRange(10).build(Vinery.identifier("mule").toString()));
    public static final RegistrySupplier<EntityType<WanderingWinemakerEntity>> WANDERING_WINEMAKER = EntityTypeRegistry.registerEntity("wandering_winemaker", () -> EntityType.Builder.of(WanderingWinemakerEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.95f).clientTrackingRange(10).build(Vinery.identifier("wandering_winemaker").toString()));
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityTypeRegistry.registerEntity("chair", () -> EntityType.Builder.of(ChairEntity::new, (MobCategory)MobCategory.MISC).sized(0.001f, 0.001f).build(Vinery.identifier("chair").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(Vinery.identifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(Vinery.identifier(path), type);
    }

    static void registerAttributes() {
        EntityAttributeRegistry.register(MULE, () -> Llama.createAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.2f));
        EntityAttributeRegistry.register(WANDERING_WINEMAKER, () -> Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 16.0));
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

