/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.components.WineYearComponent;
import net.satisfy.vinery.core.registry.DataComponentRegistry;
import net.satisfy.vinery.platform.PlatformHelper;

public class WineYears {
    public static final int YEARS_START = 0;
    public static final int MAX_LEVEL = PlatformHelper.getWineMaxLevel();
    public static final int START_DURATION = PlatformHelper.getWineStartDuration();
    public static final int DURATION_PER_YEAR = PlatformHelper.getWineDurationPerYear();
    public static final int DAYS_PER_YEAR = PlatformHelper.getWineDaysPerYear();
    public static final int YEARS_PER_EFFECT_LEVEL = PlatformHelper.getWineYearsPerEffectLevel();
    public static final int MAX_DURATION = PlatformHelper.getWineMaxDuration();

    public static int getYear(Level world) {
        return world != null ? 0 + (int)(world.getGameTime() / 24000L / (long)DAYS_PER_YEAR) : 0;
    }

    public static int getDays(Level world) {
        return world != null ? (int)(world.getGameTime() / 24000L) : 0;
    }

    public static int getWineAge(ItemStack wine, Level world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getYear(world) - y);
    }

    public static int getWineAgeDays(ItemStack wine, Level world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getDays(world) - y * DAYS_PER_YEAR);
    }

    public static int getEffectLevel(ItemStack wine, Level world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.max(0, Math.min(MAX_LEVEL, YEARS_PER_EFFECT_LEVEL > 0 ? age / YEARS_PER_EFFECT_LEVEL : 0));
    }

    public static int getEffectDuration(ItemStack wine, Level world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.min(MAX_DURATION, Math.max(0, START_DURATION + DURATION_PER_YEAR * age));
    }

    public static void setWineYear(ItemStack wine, Level world) {
        int year = world != null ? WineYears.getYear(world) : 0;
        int amplifier = WineYears.getEffectLevel(wine, world);
        int duration = WineYears.getEffectDuration(wine, world);
        wine.set((DataComponentType)DataComponentRegistry.WINE_YEAR.get(), (Object)new WineYearComponent(year, amplifier, duration));
    }

    public static void refreshCached(ItemStack wine, Level world) {
        WineYearComponent existing = (WineYearComponent)wine.get((DataComponentType)DataComponentRegistry.WINE_YEAR.get());
        int year = existing != null ? existing.year() : WineYears.getYear(world);
        int amplifier = WineYears.getEffectLevel(wine, world);
        int duration = WineYears.getEffectDuration(wine, world);
        wine.set((DataComponentType)DataComponentRegistry.WINE_YEAR.get(), (Object)new WineYearComponent(year, amplifier, duration));
    }

    public static int getWineYear(ItemStack wine) {
        WineYearComponent comp = (WineYearComponent)wine.get((DataComponentType)DataComponentRegistry.WINE_YEAR.get());
        return comp != null ? comp.year() : 0;
    }

    public static boolean hasWineYear(ItemStack wine) {
        return wine.get((DataComponentType)DataComponentRegistry.WINE_YEAR.get()) != null;
    }
}

