/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.medieval_craft_weapons.network;

import java.util.HashMap;
import net.mcreator.medieval_craft_weapons.MedievalCraftWeaponsMod;
import net.mcreator.medieval_craft_weapons.procedures.ASBluePrintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.AxeblueprintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.GreatswordBluePrintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.LBluePrintPProcedure;
import net.mcreator.medieval_craft_weapons.procedures.MaceBluePrintProcedure;
import net.mcreator.medieval_craft_weapons.procedures.SpearBPProcedure;
import net.mcreator.medieval_craft_weapons.world.inventory.ProjectBenchGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ProjectBenchGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ProjectBenchGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"medieval_craft_weapons", (String)"project_bench_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProjectBenchGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ProjectBenchGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ProjectBenchGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(ProjectBenchGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                ProjectBenchGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = ProjectBenchGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            LBluePrintPProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ASBluePrintProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SpearBPProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            MaceBluePrintProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GreatswordBluePrintProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            AxeblueprintProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MedievalCraftWeaponsMod.addNetworkMessage(TYPE, STREAM_CODEC, ProjectBenchGUIButtonMessage::handleData);
    }
}

