/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.fabric.config;

import com.fizzware.dramaticdoors.fabric.config.ModConfigProvider;
import com.fizzware.dramaticdoors.fabric.config.SimpleConfig;
import oshi.util.tuples.Pair;

public class DDConfigCommon {
    public static final String CATEGORY_EXPERIMENTAL = "Experimental";
    public static final String CATEGORY_MIXINS = "Mixins";
    public static final String CONFIG_DEV_MODE = "dev_mode";
    public static final String CONFIG_WATERLOGGABLE_DOORS = "waterloggable_doors";
    public static final String CONFIG_WATERLOGGABLE_GATES = "waterloggable_fence_gates";
    private static ModConfigProvider configProvider;
    public static SimpleConfig CONFIG;
    public static boolean devMode;
    public static boolean waterloggableDoors;
    public static boolean waterloggableFenceGates;

    public static void initializeConfigs() {
        configProvider = new ModConfigProvider();
        DDConfigCommon.createConfigs();
        CONFIG = SimpleConfig.of("dramaticdoors-startup").provider(configProvider).request();
        DDConfigCommon.assignConfigs();
    }

    private static void createConfigs() {
        configProvider.addComment("Dramatic Doors");
        configProvider.addCategory(CATEGORY_EXPERIMENTAL);
        configProvider.addKeyValuePair(new Pair((Object)CONFIG_DEV_MODE, (Object)false), "Development mode ensures that all compat doors are always registered regardless of whether mods are installed or not, for development purposes.");
        configProvider.addNewLine();
        configProvider.addCategory(CATEGORY_MIXINS);
        configProvider.addKeyValuePair(new Pair((Object)CONFIG_WATERLOGGABLE_DOORS, (Object)true), "Allows doors to be waterlogged. Enable to allow waterlogging, disable for compatibility with certain mods.  Requires restart after changing.");
        configProvider.addKeyValuePair(new Pair((Object)CONFIG_WATERLOGGABLE_GATES, (Object)true), "Allows fence gates to be waterlogged. Enable to allow waterlogging, disable for compatibility with certain mods.  Requires restart after changing.");
    }

    private static void assignConfigs() {
        devMode = CONFIG.getOrDefault(CONFIG_DEV_MODE, false);
        waterloggableDoors = CONFIG.getOrDefault(CONFIG_WATERLOGGABLE_DOORS, true);
        waterloggableFenceGates = CONFIG.getOrDefault(CONFIG_WATERLOGGABLE_GATES, true);
    }

    static {
        devMode = false;
        waterloggableDoors = true;
        waterloggableFenceGates = true;
    }
}

