/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.neoforge.compat.Compats;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;

public class ShortWeatheringDoorBlock
extends ShortDoorBlock
implements WeatheringCopper {
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ShortWeatheringDoorBlock.buildWeatheringList().build());
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());
    public static final Supplier<BiMap<Block, Block>> WAXABLES = Suppliers.memoize(() -> ShortWeatheringDoorBlock.buildWaxingList().build());
    public static final Supplier<BiMap<Block, Block>> WAX_OFF_BY_BLOCK = Suppliers.memoize(() -> WAXABLES.get().inverse());
    public static final MapCodec<ShortWeatheringDoorBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(ShortDoorBlock::type), (App)WeatheringCopper.WeatherState.CODEC.fieldOf("weathering_state").forGetter(ShortWeatheringDoorBlock::getAge), (App)ShortWeatheringDoorBlock.propertiesCodec()).apply((Applicative)inst, ShortWeatheringDoorBlock::new));
    private final WeatheringCopper.WeatherState weatherState;

    private static ImmutableBiMap.Builder<Block, Block> buildWeatheringList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_copper_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_exposed_copper_door"))));
        builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_exposed_copper_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_weathered_copper_door"))));
        builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_weathered_copper_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_oxidized_copper_door"))));
        if (Compats.modChecker.isModLoaded("immersive_weathering")) {
            builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_iron_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_exposed_iron_door"))));
            builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_exposed_iron_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_weathered_iron_door"))));
            builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_weathered_iron_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_rusted_iron_door"))));
        }
        return builder;
    }

    private static ImmutableBiMap.Builder<Block, Block> buildWaxingList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_copper_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_copper_door"))));
        builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_exposed_copper_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_exposed_copper_door"))));
        builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_weathered_copper_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_weathered_copper_door"))));
        builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_oxidized_copper_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_oxidized_copper_door"))));
        if (Compats.modChecker.isModLoaded("immersive_weathering")) {
            builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_iron_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_iron_door"))));
            builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_exposed_iron_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_exposed_iron_door"))));
            builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_weathered_iron_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_weathered_iron_door"))));
            builder.put((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_rusted_iron_door"))), (Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_rusted_iron_door"))));
        }
        return builder;
    }

    public MapCodec<ShortWeatheringDoorBlock> codec() {
        return CODEC;
    }

    public ShortWeatheringDoorBlock(BlockSetType blockset, WeatheringCopper.WeatherState state, BlockBehaviour.Properties properties) {
        super(blockset, properties);
        this.weatherState = state;
    }

    public static Optional<BlockState> getWaxed(BlockState state) {
        return Optional.ofNullable((Block)WAXABLES.get().get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
    }

    public static Optional<BlockState> getUnwaxed(BlockState state) {
        return Optional.ofNullable((Block)WAX_OFF_BY_BLOCK.get().get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
    }

    public static Optional<Block> getPrevious(Block p_154891_) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)p_154891_));
    }

    public static Block getFirst(Block p_154898_) {
        Block block = p_154898_;
        Block block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)p_154898_);
        while (block1 != null) {
            block = block1;
            block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)block1);
        }
        return block;
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return ShortWeatheringDoorBlock.getPrevious(state.getBlock()).map(p_154903_ -> p_154903_.withPropertiesOf(state));
    }

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)block));
    }

    public static BlockState getFirst(BlockState state) {
        return ShortWeatheringDoorBlock.getFirst(state.getBlock()).withPropertiesOf(state);
    }

    public Optional<BlockState> getNext(BlockState blockstate) {
        return ShortWeatheringDoorBlock.getNext(blockstate.getBlock()).map(p_154896_ -> p_154896_.withPropertiesOf(blockstate));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomsource) {
        this.changeOverTime(state, level, pos, randomsource);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return ShortWeatheringDoorBlock.getNext(state.getBlock()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

