/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.compat;

import com.fizzware.dramaticdoors.neoforge.compat.Compats;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DDCompatRecipe {
    public static List<JsonObject> SHORT_DOOR_RECIPES = new ArrayList<JsonObject>();
    public static List<JsonObject> TALL_DOOR_RECIPES = new ArrayList<JsonObject>();

    public static JsonObject createShortDoorRecipe(String recipeID, ResourceLocation baseDoor) {
        JsonObject json = DDCompatRecipe.createStonecutterRecipeJson(ResourceLocation.fromNamespaceAndPath((String)baseDoor.getNamespace(), (String)baseDoor.getPath()), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)recipeID));
        SHORT_DOOR_RECIPES.add(json);
        return json;
    }

    public static void createShortDoorRecipe(String recipeID, ResourceLocation baseDoor, boolean isWood) {
        if (isWood) {
            if (Compats.isModLoaded("woodworks", Compats.modChecker, true) || Compats.isModLoaded("aurorasdeco", Compats.modChecker, true)) {
                JsonObject json;
                if (Compats.WOODWORKS_INSTALLED) {
                    json = DDCompatRecipe.createSawmillRecipeJson(ResourceLocation.fromNamespaceAndPath((String)baseDoor.getNamespace(), (String)baseDoor.getPath()), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)recipeID), "woodworks:sawmill");
                    SHORT_DOOR_RECIPES.add(json);
                }
                if (Compats.isModLoaded("aurorasdeco", Compats.modChecker)) {
                    json = DDCompatRecipe.createSawmillRecipeJson(ResourceLocation.fromNamespaceAndPath((String)baseDoor.getNamespace(), (String)baseDoor.getPath()), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)recipeID), "aurorasdeco:woodcutting");
                    SHORT_DOOR_RECIPES.add(json);
                }
            } else {
                JsonObject json = DDCompatRecipe.createStonecutterRecipeJson(ResourceLocation.fromNamespaceAndPath((String)baseDoor.getNamespace(), (String)baseDoor.getPath()), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)recipeID));
                SHORT_DOOR_RECIPES.add(json);
            }
        } else {
            JsonObject json = DDCompatRecipe.createStonecutterRecipeJson(ResourceLocation.fromNamespaceAndPath((String)baseDoor.getNamespace(), (String)baseDoor.getPath()), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)recipeID));
            SHORT_DOOR_RECIPES.add(json);
        }
    }

    public static void createTallDoorRecipe(String recipeID, ResourceLocation baseDoor, @Nullable String group) {
        JsonObject json = DDCompatRecipe.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#')}), Lists.newArrayList((Object[])new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)baseDoor.getNamespace(), (String)baseDoor.getPath())}), Lists.newArrayList((Object[])new String[]{"item"}), Lists.newArrayList((Object[])new String[]{"#", "#", "#"}), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)recipeID), group);
        TALL_DOOR_RECIPES.add(json);
    }

    public static JsonObject createShapedRecipeJson(ArrayList<Character> keys, ArrayList<ResourceLocation> items, ArrayList<String> type, ArrayList<String> pattern, ResourceLocation output, @Nullable String group) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        if (group != null) {
            json.addProperty("group", group);
        }
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(pattern.get(0));
        jsonArray.add(pattern.get(1));
        jsonArray.add(pattern.get(2));
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), items.get(i).toString());
            keyList.add(String.valueOf(keys.get(i)), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)2);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createStonecutterRecipeJson(ResourceLocation input, ResourceLocation output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:stonecutting");
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", input.toString());
        json.add("ingredient", (JsonElement)ingredient);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)2);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createSawmillRecipeJson(ResourceLocation input, ResourceLocation output, String recipeType) {
        JsonObject json = new JsonObject();
        json.addProperty("type", recipeType);
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", input.toString());
        json.add("ingredient", (JsonElement)ingredient);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)2);
        json.add("result", (JsonElement)result);
        return json;
    }
}

