/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.compat.registries;

import com.fizzware.dramaticdoors.neoforge.compat.CompatChecker;
import com.fizzware.dramaticdoors.neoforge.compat.Compats;
import com.fizzware.dramaticdoors.neoforge.compat.DDCompatAdvancement;
import com.fizzware.dramaticdoors.neoforge.compat.DDCompatRecipe;
import com.fizzware.dramaticdoors.neoforge.registry.DDRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;

public class TwilightForestCompat {
    public static void registerCompat(CompatChecker checker) {
        TwilightForestCompat.registerBlocksItems(checker);
        TwilightForestCompat.registerRecipes(checker);
    }

    private static void registerBlocksItems(CompatChecker checker) {
        DDRegistry.registerDoorBlockAndItem("tall_canopy_door", "short_canopy_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"canopy_door")), BlockSetType.OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_darkwood_door", "short_darkwood_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"dark_door")), BlockSetType.OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_twilight_mangrove_door", "short_twilight_mangrove_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mangrove_door")), BlockSetType.MANGROVE, true);
        DDRegistry.registerDoorBlockAndItem("tall_minewood_door", "short_minewood_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mining_door")), BlockSetType.OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_sortingwood_door", "short_sortingwood_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"sorting_door")), BlockSetType.OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_timewood_door", "short_timewood_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"time_door")), BlockSetType.OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_transwood_door", "short_transwood_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"transformation_door")), BlockSetType.OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_twilight_oak_door", "short_twilight_oak_door", DDRegistry.getBlockFromResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_oak_door")), BlockSetType.OAK, true);
        if (Compats.isModLoaded("tflostblocks", checker)) {
            DDRegistry.registerDoorBlockAndItem("tall_thorn_door", "short_thorn_door", BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(50.0f, 2000.0f).noOcclusion(), BlockSetType.OAK, true);
            DDRegistry.registerDoorBlockAndItem("tall_towerwood_door", "short_towerwood_door", BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(40.0f, 6.0f).noOcclusion(), BlockSetType.OAK, true);
        }
    }

    private static void registerRecipes(CompatChecker checker) {
        DDCompatAdvancement.createRecipeAdvancement("short_canopy_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"canopy_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("short_darkwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"dark_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("short_twilight_mangrove_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mangrove_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("short_minewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mining_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("short_sortingwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"sorting_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("short_timewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"time_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("short_transwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"transformation_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("short_twilight_oak_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_oak_door"), true);
        DDCompatAdvancement.createRecipeAdvancement("tall_canopy_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"canopy_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_darkwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"dark_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_twilight_mangrove_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mangrove_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_minewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mining_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_sortingwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"sorting_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_timewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"time_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_transwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"transformation_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_twilight_oak_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_oak_door"));
        DDCompatRecipe.createShortDoorRecipe("short_canopy_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"canopy_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_darkwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"dark_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_twilight_mangrove_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mangrove_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_minewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mining_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_sortingwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"sorting_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_timewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"time_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_transwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"transformation_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_twilight_oak_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_oak_door"), true);
        DDCompatRecipe.createTallDoorRecipe("tall_canopy_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"canopy_door"), "tall_tf_wooden_door");
        DDCompatRecipe.createTallDoorRecipe("tall_darkwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"dark_door"), "tall_tf_wooden_door");
        DDCompatRecipe.createTallDoorRecipe("tall_twilight_mangrove_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mangrove_door"), "tall_tf_wooden_door");
        DDCompatRecipe.createTallDoorRecipe("tall_minewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"mining_door"), "tall_tf_wooden_door");
        DDCompatRecipe.createTallDoorRecipe("tall_sortingwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"sorting_door"), "tall_tf_wooden_door");
        DDCompatRecipe.createTallDoorRecipe("tall_timewood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"time_door"), "tall_tf_wooden_door");
        DDCompatRecipe.createTallDoorRecipe("tall_transwood_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"transformation_door"), "tall_tf_wooden_door");
        DDCompatRecipe.createTallDoorRecipe("tall_twilight_oak_door", ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_oak_door"), "tall_tf_wooden_door");
        if (Compats.isModLoaded("tflostblocks", checker)) {
            DDCompatAdvancement.createRecipeAdvancement("short_thorn_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"thorn_door"));
            DDCompatAdvancement.createRecipeAdvancement("tall_thorn_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"thorn_door"));
            DDCompatAdvancement.createRecipeAdvancement("short_towerwood_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"towerwood_door"));
            DDCompatAdvancement.createRecipeAdvancement("tall_towerwood_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"towerwood_door"));
            DDCompatRecipe.createShortDoorRecipe("short_thorn_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"thorn_door"), true);
            DDCompatRecipe.createTallDoorRecipe("tall_thorn_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"thorn_door"), "tall_tf_wooden_door");
            DDCompatRecipe.createShortDoorRecipe("short_towerwood_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"towerwood_door"), true);
            DDCompatRecipe.createTallDoorRecipe("tall_towerwood_door", ResourceLocation.fromNamespaceAndPath((String)"tflostblocks", (String)"towerwood_door"), "tall_tf_wooden_door");
        }
    }
}

