/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.datagen;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class DDBlockStateProvider
extends BlockStateProvider {
    public DDBlockStateProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "dramaticdoors", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.shortDoorBlock((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_birch_door")), "block/short_birch");
        this.tallDoorBlock((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_birch_door")), "block/tall_birch");
    }

    private void tallDoorBlock(Block block, String baseName) {
        this.internalTallDoorBlock((TallDoorBlock)block, baseName, ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)(baseName + "_door_bottom")), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)(baseName + "_door_middle")), ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)(baseName + "_door_top")));
    }

    private void shortDoorBlock(Block block, String baseName) {
        this.internalShortDoorBlock((ShortDoorBlock)block, baseName, ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)(baseName + "_door")));
    }

    private void internalTallDoorBlock(TallDoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation middle, ResourceLocation top) {
        ModelBuilder bottomLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_left", ":block/door_bottom_left")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_left_open", "block/door_bottom_left_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_right", "block/door_bottom_right")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_right_open", "block/door_bottom_right_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder middleLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_left", "dramaticdoors:block/door_middle_left")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_left_open", "dramaticdoors:block/door_middle_left_open")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_right", "dramaticdoors:block/door_middle_right")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_right_open", "dramaticdoors:block/door_middle_right_open")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder topLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_left", "block/door_top_left")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_left_open", "block/door_top_left_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_right", "block/door_top_right")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_right_open", "block/door_top_right_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        this.tallDoorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)middleLeft, (ModelFile)middleLeftOpen, (ModelFile)middleRight, (ModelFile)middleRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    private void internalShortDoorBlock(ShortDoorBlock block, String baseName, ResourceLocation tex) {
        ModelBuilder left = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_left", "dramaticdoors:block/door_short_left")).texture("texture", tex);
        ModelBuilder leftOpen = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_left_open", "dramaticdoors:block/door_short_left_open")).texture("texture", tex);
        ModelBuilder right = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_right", "dramaticdoors:block/door_short_right")).texture("texture", tex);
        ModelBuilder rightOpen = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_right_open", "dramaticdoors:block/door_short_right_open")).texture("texture", tex);
        this.shortDoorBlock(block, (ModelFile)left, (ModelFile)leftOpen, (ModelFile)right, (ModelFile)rightOpen);
    }

    public void tallDoorBlock(TallDoorBlock block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile middleLeft, ModelFile middleLeftOpen, ModelFile middleRight, ModelFile middleRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.getValue((Property)TallDoorBlock.FACING)).toYRot() + 90;
            TripleBlockPart third = (TripleBlockPart)((Object)((Object)state.getValue(TallDoorBlock.THIRD)));
            boolean right = state.getValue(TallDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.getValue((Property)TallDoorBlock.OPEN);
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            switch (third) {
                default: {
                    if (right && open) {
                        model = bottomRightOpen;
                    } else if (!right && open) {
                        model = bottomLeftOpen;
                    }
                    if (right && !open) {
                        model = bottomRight;
                        break;
                    }
                    if (right || open) break;
                    model = bottomLeft;
                    break;
                }
                case MIDDLE: {
                    if (right && open) {
                        model = middleRightOpen;
                    } else if (!right && open) {
                        model = middleLeftOpen;
                    }
                    if (right && !open) {
                        model = middleRight;
                        break;
                    }
                    if (right || open) break;
                    model = middleLeft;
                    break;
                }
                case UPPER: {
                    if (right && open) {
                        model = topRightOpen;
                    } else if (!right && open) {
                        model = topLeftOpen;
                    }
                    if (right && !open) {
                        model = topRight;
                        break;
                    }
                    if (right || open) break;
                    model = topLeft;
                }
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new Property[]{TallDoorBlock.POWERED, TallDoorBlock.WATERLOGGED});
    }

    public void shortDoorBlock(ShortDoorBlock block, ModelFile left, ModelFile leftOpen, ModelFile right, ModelFile rightOpen) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.getValue((Property)ShortDoorBlock.FACING)).toYRot() + 90;
            boolean isRight = state.getValue(ShortDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.getValue((Property)ShortDoorBlock.OPEN);
            if (open) {
                yRot += 90;
            }
            if (isRight && open) {
                yRot += 180;
            }
            ModelFile model = null;
            model = isRight ? (open ? rightOpen : right) : (open ? leftOpen : left);
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot %= 360).build();
        }, new Property[]{ShortDoorBlock.POWERED, TallDoorBlock.WATERLOGGED});
    }
}

