/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.entity.ai.goal;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.neoforge.tags.DDBlockTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class OpenShortDoorsTask {
    private static final int RUN_TIME = 20;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject mutableObject = new MutableObject(null);
        MutableInt mutableInt = new MutableInt(0);
        return BehaviorBuilder.create(context -> context.group((App)context.present(MemoryModuleType.PATH), (App)context.registered(MemoryModuleType.DOORS_TO_CLOSE), (App)context.registered(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)context, (pathRaw, doorsToClose, mobs) -> (world, entity, time) -> {
            ShortDoorBlock doorBlock2;
            BlockPos blockPos2;
            BlockState blockState2;
            Path path = (Path)context.get(pathRaw);
            Optional optional = context.tryGet(doorsToClose);
            if (path.notStarted() || path.isDone()) {
                return false;
            }
            if (Objects.equals(mutableObject.getValue(), path.getNextNode())) {
                mutableInt.setValue(20);
            } else if (mutableInt.decrementAndGet() > 0) {
                return false;
            }
            mutableObject.setValue((Object)path.getNextNode());
            Node pathNode = path.getPreviousNode();
            Node pathNode2 = path.getNextNode();
            BlockPos blockPos = pathNode.asBlockPos();
            BlockState blockState = world.getBlockState(blockPos);
            if (blockState.is(DDBlockTags.MOB_INTERACTABLE_SHORT_DOORS, state -> state.getBlock() instanceof ShortDoorBlock)) {
                ShortDoorBlock doorBlock = (ShortDoorBlock)blockState.getBlock();
                if (!doorBlock.isOpen(blockState)) {
                    doorBlock.setOpen((Entity)entity, (Level)world, blockState, blockPos, true);
                }
                optional = InteractWithDoor.rememberDoorToClose((MemoryAccessor)doorsToClose, (Optional)optional, (ServerLevel)world, (BlockPos)blockPos);
            }
            if ((blockState2 = world.getBlockState(blockPos2 = pathNode2.asBlockPos())).is(DDBlockTags.MOB_INTERACTABLE_SHORT_DOORS, state -> state.getBlock() instanceof ShortDoorBlock) && !(doorBlock2 = (ShortDoorBlock)blockState2.getBlock()).isOpen(blockState2)) {
                doorBlock2.setOpen((Entity)entity, (Level)world, blockState2, blockPos2, true);
                optional = InteractWithDoor.rememberDoorToClose((MemoryAccessor)doorsToClose, (Optional)optional, (ServerLevel)world, (BlockPos)blockPos2);
            }
            optional.ifPresent(doors -> InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough((ServerLevel)world, (LivingEntity)entity, (Node)pathNode, (Node)pathNode2, (Set)doors, (Optional)context.tryGet(mobs)));
            return true;
        }));
    }
}

