/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DoorBlock.class})
public class DoorBlockMixin
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public DoorBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/block/state/properties/BlockSetType;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V"})
    private void enhanceConstructor(BlockSetType blockset, BlockBehaviour.Properties properties, CallbackInfo callback) {
        ((DoorBlock)this).registerDefaultState((BlockState)((DoorBlock)this).defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(at={@At(value="TAIL")}, method={"createBlockStateDefinition(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V"})
    protected void injectBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo callback) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Inject(at={@At(value="HEAD")}, method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, cancellable=true)
    private void getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> callback) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        if (blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(context)) {
            boolean flag = level.hasNeighborSignal(blockpos) || level.hasNeighborSignal(blockpos.above());
            boolean waterfilled = level.getFluidState(blockpos).getType() == Fluids.WATER;
            callback.setReturnValue((Object)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((DoorBlock)this).defaultBlockState().setValue((Property)DoorBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)DoorBlock.HINGE, (Comparable)((DoorBlock)this).getHinge(context))).setValue((Property)DoorBlock.POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(flag))).setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled))));
        } else {
            callback.setReturnValue(null);
        }
        callback.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"updateShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, cancellable=true)
    private void injectUpdateShape(BlockState stateIn, Direction direction, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> callback) {
        if (stateIn.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.getValue((Property)DoorBlock.HALF);
            if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
                accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
            }
            if (direction.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (direction == Direction.UP)) {
                callback.setReturnValue((Object)(doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !stateIn.canSurvive((LevelReader)accessor, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, direction, facingState, accessor, currentPos, facingPos)));
            } else {
                callback.setReturnValue((Object)(facingState.getBlock() instanceof DoorBlock && facingState.getValue((Property)DoorBlock.HALF) != doubleblockhalf ? (BlockState)((BlockState)facingState.setValue((Property)DoorBlock.HALF, (Comparable)doubleblockhalf)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(accessor.getFluidState(currentPos).getType() == Fluids.WATER)) : Blocks.AIR.defaultBlockState()));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setPlacedBy(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V"}, cancellable=true)
    private void injectPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack, CallbackInfo callback) {
        boolean waterfilled = level.getFluidState(pos.above()).getType() == Fluids.WATER;
        level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled)), 3);
        callback.cancel();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }
}

