/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.misc.RollingBuffer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleTrailEmitter {
    private final double wantedSpacing;
    private final int maxParticlesPerTick;
    private final int minParticlesPerTick;
    private final double minSpeed;
    private Vec3 lastEmittedPos = null;
    private final RollingBuffer<Vec3> previousVelocities = new RollingBuffer(3);
    private final RollingBuffer<Vec3> previousPositions = new RollingBuffer(3);

    private ParticleTrailEmitter(Builder builder) {
        this.wantedSpacing = builder.idealSpacing;
        this.maxParticlesPerTick = builder.maxParticlesPerTick;
        this.minParticlesPerTick = builder.minParticlesPerTick;
        this.minSpeed = builder.minSpeed;
    }

    public void tick(Entity obj, ParticleOptions particleOptions) {
        this.tick(obj, particleOptions, true);
    }

    public void tick(Entity obj, ParticleOptions particleOptions, boolean followSpeed) {
        this.tick(obj, (Vec3 position, Vec3 velocity) -> {
            Level level = obj.level();
            if (followSpeed) {
                level.addParticle(particleOptions, position.x, position.y, position.z, velocity.x, velocity.y, velocity.z);
            } else {
                level.addParticle(particleOptions, position.x, position.y, position.z, 0.0, 0.0, 0.0);
            }
        });
    }

    public void tick(Entity obj, Emitter emitter) {
        double t;
        Vec3 movement = obj.getDeltaMovement();
        this.previousVelocities.push(movement);
        this.previousPositions.push(obj.position());
        if (this.previousPositions.size() < 2) {
            return;
        }
        if (movement.lengthSqr() < this.minSpeed * this.minSpeed) {
            return;
        }
        Vec3 startPos = this.previousPositions.get(0);
        Vec3 endPos = this.previousPositions.get(1);
        Vec3 startVel = this.previousVelocities.get(0);
        Vec3 endVel = this.previousVelocities.get(1);
        if (this.lastEmittedPos == null) {
            this.lastEmittedPos = startPos;
            return;
        }
        double segmentLength = startPos.distanceTo(endPos);
        Double startT = ParticleTrailEmitter.intersectSphereSegment(this.lastEmittedPos, this.wantedSpacing, startPos, endPos);
        if (startT == null) {
            return;
        }
        double remainingLength = segmentLength * (1.0 - startT);
        float spacing = (float)this.wantedSpacing;
        int particlesToEmit = 1 + (int)(remainingLength / this.wantedSpacing);
        if (particlesToEmit > this.maxParticlesPerTick) {
            particlesToEmit = this.maxParticlesPerTick;
            spacing = (float)(remainingLength / (double)particlesToEmit);
        } else if (particlesToEmit < this.minParticlesPerTick) {
            particlesToEmit = this.minParticlesPerTick;
            spacing = (float)(remainingLength / (double)particlesToEmit);
        }
        float h = obj.getBbHeight() / 2.0f;
        for (int i = 0; i < particlesToEmit && !((t = startT + (double)((float)i * spacing / (float)segmentLength)) > 1.0); ++i) {
            Vec3 position = startPos.lerp(endPos, t);
            Vec3 velocity = startVel.lerp(endVel, t);
            emitter.emitParticle(position.add(0.0, (double)h, 0.0), velocity);
            this.lastEmittedPos = position;
        }
    }

    private static Double intersectSphereSegment(Vec3 center, double radius, Vec3 start, Vec3 end) {
        double c;
        Vec3 direction = end.subtract(start);
        Vec3 oldDirection = start.subtract(center);
        double a = direction.dot(direction);
        double b = 2.0 * oldDirection.dot(direction);
        double discriminant = b * b - 4.0 * a * (c = oldDirection.dot(oldDirection) - radius * radius);
        if (discriminant < 0.0) {
            return null;
        }
        double sqrtDiscriminant = (float)Math.sqrt(discriminant);
        double t1 = (-b - sqrtDiscriminant) / (2.0 * a);
        double t2 = (-b + sqrtDiscriminant) / (2.0 * a);
        if (t1 >= 0.0 && t1 <= 1.0) {
            return Mth.clamp((double)t2, (double)0.0, (double)1.0);
        }
        if (t2 >= 0.0 && t2 <= 1.0) {
            return Mth.clamp((double)t2, (double)0.0, (double)1.0);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double idealSpacing = 0.5;
        private int maxParticlesPerTick = 5;
        private int minParticlesPerTick = 0;
        private double minSpeed = 0.0;

        public Builder spacing(double spacing) {
            this.idealSpacing = spacing;
            return this;
        }

        public Builder maxParticlesPerTick(int max) {
            this.maxParticlesPerTick = max;
            return this;
        }

        public Builder minParticlesPerTick(int min) {
            this.minParticlesPerTick = min;
            return this;
        }

        public Builder minSpeed(double speed) {
            this.minSpeed = speed;
            return this;
        }

        public ParticleTrailEmitter build() {
            if (this.minParticlesPerTick > this.maxParticlesPerTick) {
                throw new IllegalArgumentException("minParticlesPerTick cannot be greater than maxParticlesPerTick");
            }
            return new ParticleTrailEmitter(this);
        }
    }

    public static interface Emitter {
        public void emitParticle(Vec3 var1, Vec3 var2);
    }
}

