/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RegistryCommand {
    private static final long PAGE_SIZE = 8L;
    private static final ResourceKey<Registry<Registry<?>>> ROOT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"root"));
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY = new DynamicCommandExceptionType(key -> Component.translatable((String)"commands.moonlight.registry.error.unknown_registry", (Object[])new Object[]{key.toString()}));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"registry").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"registry", (ArgumentType)ResourceKeyArgument.key(ROOT_REGISTRY_KEY)).suggests(RegistryCommand::suggestRegistries).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, 1, null))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), null))))).then(Commands.literal((String)"search").then(((RequiredArgumentBuilder)Commands.argument((String)"keyword", (ArgumentType)StringArgumentType.string()).executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, 1, StringArgumentType.getString((CommandContext)ctx, (String)"keyword")))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), StringArgumentType.getString((CommandContext)ctx, (String)"keyword"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"dump").requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"file_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String fileName = StringArgumentType.getString((CommandContext)ctx, (String)"file_name");
            return RegistryCommand.dumpRegistry((CommandContext<CommandSourceStack>)ctx, fileName);
        }))));
    }

    private static int dumpRegistry(CommandContext<CommandSourceStack> ctx, String fileName) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = RegistryCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Registry registry = (Registry)source.getServer().registryAccess().registry(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.location()));
        Path dir = PlatHelper.getGamePath().resolve("registry_dumps");
        if (!dir.toFile().exists()) {
            dir.toFile().mkdirs();
        }
        Path file = dir.resolve(fileName + ".txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file.toFile()));){
            for (Object entry : registry) {
                writer.write(entry.toString());
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(() -> "I/O error"), e::getMessage);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.moonlight.registry.dump.success", (Object[])new Object[]{file.toString()}), false);
        return 0;
    }

    private static int listElements(CommandContext<CommandSourceStack> ctx, int page, @Nullable String search) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = RegistryCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Registry registry = (Registry)source.getServer().registryAccess().registry(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.location()));
        long elementCount = registry.size();
        source.sendSuccess(() -> RegistryCommand.createMessage(Component.translatable((String)"commands.moonlight.registry.registry_key", (Object[])new Object[]{Component.literal((String)registryKey.location().toString()).withStyle(ChatFormatting.GOLD)}), page, () -> registry.keySet().stream().map(ResourceLocation::toString), search), false);
        return (int)elementCount;
    }

    private static MutableComponent createMessage(MutableComponent header, long currentPage, Supplier<Stream<String>> names, @Nullable String search) {
        List<String> filtered = names.get().filter(s -> search == null || s.contains(search)).toList();
        long count = filtered.size();
        String allElementNames = filtered.stream().sorted().collect(Collectors.joining("\n"));
        long totalPages = (count - 1L) / 8L + 1L;
        long actualPage = (long)Mth.clamp((float)currentPage, (float)1.0f, (float)totalPages);
        MutableComponent component = Component.translatable((String)"commands.moonlight.registry.elements_count", (Object[])new Object[]{count});
        if (count > 0L) {
            component = ComponentUtils.wrapInSquareBrackets((Component)component.withStyle(s -> s.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, allElementNames)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"commands.moonlight.registry.copy_elements_names")))));
            component = Component.translatable((String)"commands.moonlight.registry.page_info", (Object[])new Object[]{component, actualPage, totalPages});
        }
        MutableComponent tagElements = Component.literal((String)"").append((Component)component);
        Stream<MutableComponent> stream = filtered.stream().sorted().skip(8L * (actualPage - 1L)).limit(8L).map(Component::literal).map(t -> t.withStyle(ChatFormatting.DARK_GREEN)).map(t -> Component.literal((String)"\n - ").append((Component)t));
        Objects.requireNonNull(tagElements);
        stream.forEach(arg_0 -> ((MutableComponent)tagElements).append(arg_0));
        return header.append("\n").append((Component)tagElements);
    }

    private static CompletableFuture<Suggestions> suggestRegistries(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Stream<String> strings = ((CommandSourceStack)ctx.getSource()).registryAccess().registries().map(RegistryAccess.RegistryEntry::key).map(ResourceKey::location).map(ResourceLocation::toString);
        Objects.requireNonNull(builder);
        strings.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static <T> Optional<ResourceKey<T>> getResourceKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> registryKey) {
        ResourceKey key = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
        return key.cast(registryKey);
    }
}

